/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.datasource;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.datasource.DirectDataSourceInjectionSource;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class DataSourceDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName DATASOURCE_DEFINITION = DotName.createSimple((String)DataSourceDefinition.class.getName());
    private static final DotName DATASOURCE_DEFINITIONS = DotName.createSimple((String)DataSourceDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List datasources;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List datasourceDefinitions = index.getAnnotations(DATASOURCE_DEFINITIONS);
        if (datasourceDefinitions != null) {
            for (AnnotationInstance annotation : datasourceDefinitions) {
                AnnotationTarget target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@DataSourceDefinitions can only be applied on class. " + target + " is not a class");
                }
                List<AnnotationInstance> datasources2 = this.getNestedDataSourceAnnotations(annotation);
                for (AnnotationInstance datasource : datasources2) {
                    this.processDataSourceDefinition(eeModuleDescription, datasource, (ClassInfo)target, applicationClasses);
                }
            }
        }
        if ((datasources = index.getAnnotations(DATASOURCE_DEFINITION)) != null) {
            for (AnnotationInstance datasource : datasources) {
                AnnotationTarget target = datasource.target();
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@DataSourceDefinition can only be applied on class. " + target + " is not a class");
                }
                this.processDataSourceDefinition(eeModuleDescription, datasource, (ClassInfo)target, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processDataSourceDefinition(EEModuleDescription eeModuleDescription, AnnotationInstance datasourceDefinition, ClassInfo targetClass, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        final BindingConfiguration bindingConfiguration = this.getBindingConfiguration(datasourceDefinition);
        EEModuleClassDescription classDescription = applicationClasses.getOrAddClassByName(targetClass.name().toString());
        classDescription.getConfigurators().add(new ClassConfigurator(){

            @Override
            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
            }
        });
    }

    private BindingConfiguration getBindingConfiguration(AnnotationInstance datasourceAnnotation) {
        AnnotationValue classValue;
        AnnotationValue nameValue = datasourceAnnotation.value("name");
        if (nameValue == null || nameValue.asString().isEmpty()) {
            throw new IllegalArgumentException("@DataSourceDefinition annotations must provide a name.");
        }
        String name = nameValue.asString();
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        if ((classValue = datasourceAnnotation.value("className")) == null || classValue.asString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("@DataSourceDefinition annotations must provide a driver class name.");
        }
        String type = classValue.asString();
        DirectDataSourceInjectionSource directDataSourceInjectionSource = new DirectDataSourceInjectionSource();
        directDataSourceInjectionSource.setClassName(type);
        directDataSourceInjectionSource.setDatabaseName(this.asString(datasourceAnnotation, "databaseName"));
        directDataSourceInjectionSource.setDescription(this.asString(datasourceAnnotation, "description"));
        directDataSourceInjectionSource.setInitialPoolSize(this.asInt(datasourceAnnotation, "initialPoolSize"));
        directDataSourceInjectionSource.setIsolationLevel(this.asInt(datasourceAnnotation, "isolationLevel"));
        directDataSourceInjectionSource.setLoginTimeout(this.asInt(datasourceAnnotation, "loginTimeout"));
        directDataSourceInjectionSource.setMaxIdleTime(this.asInt(datasourceAnnotation, "maxIdleTime"));
        directDataSourceInjectionSource.setMaxStatements(this.asInt(datasourceAnnotation, "maxStatements"));
        directDataSourceInjectionSource.setMaxPoolSize(this.asInt(datasourceAnnotation, "maxPoolSize"));
        directDataSourceInjectionSource.setMinPoolSize(this.asInt(datasourceAnnotation, "minPoolSize"));
        directDataSourceInjectionSource.setPassword(this.asString(datasourceAnnotation, "password"));
        directDataSourceInjectionSource.setPortNumber(this.asInt(datasourceAnnotation, "portNumber"));
        directDataSourceInjectionSource.setProperties(this.asArray(datasourceAnnotation, "properties"));
        directDataSourceInjectionSource.setServerName(this.asString(datasourceAnnotation, "serverName"));
        directDataSourceInjectionSource.setTransactional(this.asBool(datasourceAnnotation, "transactional"));
        directDataSourceInjectionSource.setUrl(this.asString(datasourceAnnotation, "url"));
        directDataSourceInjectionSource.setUser(this.asString(datasourceAnnotation, "user"));
        BindingConfiguration bindingDescription = new BindingConfiguration(name, directDataSourceInjectionSource);
        return bindingDescription;
    }

    private int asInt(AnnotationInstance annotation, String string) {
        AnnotationValue value = annotation.value(string);
        return value == null ? -1 : value.asInt();
    }

    private String asString(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asString();
    }

    private boolean asBool(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? true : value.asBoolean();
    }

    private String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asStringArray();
    }

    private List<AnnotationInstance> getNestedDataSourceAnnotations(AnnotationInstance datasourceDefinitions) {
        if (datasourceDefinitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = datasourceDefinitions.value().asNestedArray();
        return Arrays.asList(nested);
    }
}

