/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OrderedItemContainer<T> {
    private final Map<Integer, T> items = new HashMap<Integer, T>();
    private volatile List<T> sortedItems;

    public void add(T item, int priority) {
        if (this.sortedItems != null) {
            throw new IllegalStateException("Cannot add any more items once getSortedItems() has been called");
        }
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        T current = this.items.get(priority);
        if (current != null) {
            throw new IllegalArgumentException("AS7-1042: can't add " + item + ", priority 0x" + Integer.toHexString(priority) + " is already taken by " + current);
        }
        this.items.put(priority, item);
    }

    public List<T> getSortedItems() {
        if (this.sortedItems == null) {
            TreeMap<Integer, T> sortedMap = new TreeMap<Integer, T>(this.items);
            this.sortedItems = new ArrayList(sortedMap.values());
        }
        return this.sortedItems;
    }
}

