/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.transaction.TransactionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.security.ModulesMap;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.txn.TransactionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.JBossJSSESecurityDomain;
import org.jboss.security.JSSESecurityDomain;
import org.jboss.security.acl.config.ACLProviderEntry;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ACLInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.plugins.TransactionManagerLocator;

class SecurityDomainAdd
extends AbstractAddStepHandler {
    static final String OPERATION_NAME = "add";
    private static final String CACHE_CONTAINER_NAME = "security";
    static final SecurityDomainAdd INSTANCE = new SecurityDomainAdd();

    static final ModelNode getRecreateOperation(ModelNode address, ModelNode securityDomain) {
        return Util.getOperation((String)OPERATION_NAME, (ModelNode)address, (ModelNode)securityDomain);
    }

    private SecurityDomainAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        Util.copyParamsToModel((ModelNode)operation, (ModelNode)model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String securityDomain = address.getLastElement().getValue();
        ApplicationPolicy applicationPolicy = this.createApplicationPolicy(securityDomain, operation);
        JSSESecurityDomain jsseSecurityDomain = this.createJSSESecurityDomain(securityDomain, operation);
        String cacheType = this.getAuthenticationCacheType(operation);
        SecurityDomainService securityDomainService = new SecurityDomainService(securityDomain, applicationPolicy, jsseSecurityDomain, cacheType);
        ServiceTarget target = context.getServiceTarget();
        Injector<TransactionManager> transactionManagerInjector = new Injector<TransactionManager>(){

            public void inject(TransactionManager value) throws InjectionException {
                TransactionManagerLocator.setTransactionManager((TransactionManager)value);
            }

            public void uninject() {
            }
        };
        ServiceBuilder builder = target.addService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}), (Service)securityDomainService).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainService.getSecurityManagementInjector()).addDependency(JaasConfigurationService.SERVICE_NAME, Configuration.class, securityDomainService.getConfigurationInjector()).addDependency(TransactionManagerService.SERVICE_NAME, TransactionManager.class, (Injector)transactionManagerInjector);
        if ("infinispan".equals(cacheType)) {
            builder.addDependency(EmbeddedCacheManagerService.getServiceName((String)CACHE_CONTAINER_NAME), EmbeddedCacheManager.class, securityDomainService.getCacheManagerInjector());
        }
        newControllers.add(builder.addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    private ApplicationPolicy createApplicationPolicy(String securityDomain, ModelNode operation) {
        AppConfigurationEntry entry;
        HashMap<String, String> options;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag;
        String codeName;
        List modules;
        AuthenticationInfo authenticationInfo;
        ApplicationPolicy applicationPolicy = null;
        ModelNode node = null;
        node = operation.get("authentication");
        if (node.isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            authenticationInfo = new AuthenticationInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require("code").asString();
                if (ModulesMap.AUTHENTICATION_MAP.containsKey(codeName)) {
                    codeName = ModulesMap.AUTHENTICATION_MAP.get(codeName);
                }
                controlFlag = this.getControlFlag(module.require("flag").asString());
                options = new HashMap<String, String>();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new AppConfigurationEntry(codeName, controlFlag, options);
                authenticationInfo.addAppConfigurationEntry(entry);
            }
            applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        }
        if ((node = operation.get("acl")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            ACLInfo aclInfo = new ACLInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require("code").asString();
                controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new ACLProviderEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                aclInfo.add((Object)entry);
            }
            applicationPolicy.setAclInfo(aclInfo);
        }
        if ((node = operation.get("audit")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            AuditInfo auditInfo = new AuditInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require("code").asString();
                HashMap<String, String> options2 = new HashMap<String, String>();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options2.put(prop.getName(), prop.getValue().asString());
                    }
                }
                AuditProviderEntry entry2 = new AuditProviderEntry(codeName, options2);
                auditInfo.add((Object)entry2);
            }
            applicationPolicy.setAuditInfo(auditInfo);
        }
        if ((node = operation.get("authorization")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            AuthorizationInfo authorizationInfo = new AuthorizationInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require("code").asString();
                if (ModulesMap.AUTHORIZATION_MAP.containsKey(codeName)) {
                    codeName = ModulesMap.AUTHORIZATION_MAP.get(codeName);
                }
                controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new AuthorizationModuleEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                authorizationInfo.add((Object)entry);
            }
            applicationPolicy.setAuthorizationInfo(authorizationInfo);
        }
        if ((node = operation.get("identity-trust")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            IdentityTrustInfo identityTrustInfo = new IdentityTrustInfo(securityDomain);
            modules = node.asList();
            for (ModelNode module : modules) {
                codeName = module.require("code").asString();
                controlFlag = ControlFlag.valueOf((String)module.require("flag").asString());
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new IdentityTrustModuleEntry(codeName, options);
                entry.setControlFlag((ControlFlag)controlFlag);
                identityTrustInfo.add((Object)entry);
            }
            applicationPolicy.setIdentityTrustInfo(identityTrustInfo);
        }
        if ((node = operation.get("mapping")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            modules = node.asList();
            String mappingType = null;
            for (ModelNode module : modules) {
                MappingInfo mappingInfo = new MappingInfo(securityDomain);
                String codeName2 = module.require("code").asString();
                if (ModulesMap.MAPPING_MAP.containsKey(codeName2)) {
                    codeName2 = ModulesMap.MAPPING_MAP.get(codeName2);
                }
                mappingType = module.hasDefined("type") ? module.get("type").asString() : MappingType.ROLE.toString();
                options = new HashMap();
                if (module.hasDefined("module-options")) {
                    for (Property prop : module.get("module-options").asPropertyList()) {
                        options.put(prop.getName(), prop.getValue().asString());
                    }
                }
                entry = new MappingModuleEntry(codeName2, options, mappingType);
                mappingInfo.add((Object)entry);
                applicationPolicy.setMappingInfo(mappingType, mappingInfo);
            }
        }
        if ((node = operation.get("authentication-jaspi")).isDefined()) {
            if (applicationPolicy == null) {
                applicationPolicy = new ApplicationPolicy(securityDomain);
            }
            authenticationInfo = new JASPIAuthenticationInfo(securityDomain);
            HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
            ModelNode moduleStack = node.get("login-module-stack");
            modules = moduleStack.asList();
            for (ModelNode loginModuleStack : modules) {
                List nodes = loginModuleStack.asList();
                Iterator iter = nodes.iterator();
                ModelNode nameNode = (ModelNode)iter.next();
                String name = nameNode.get("name").asString();
                LoginModuleStackHolder holder = new LoginModuleStackHolder(name, null);
                holders.put(name, holder);
                authenticationInfo.add(holder);
                while (iter.hasNext()) {
                    ModelNode lmsNode = (ModelNode)iter.next();
                    List lms = lmsNode.asList();
                    for (ModelNode lmNode : lms) {
                        String code = lmNode.require("code").asString();
                        AppConfigurationEntry.LoginModuleControlFlag controlFlag2 = this.getControlFlag(lmNode.require("flag").asString());
                        HashMap<String, String> options3 = new HashMap<String, String>();
                        if (lmNode.hasDefined("module-options")) {
                            for (Property prop : lmNode.get("module-options").asPropertyList()) {
                                options3.put(prop.getName(), prop.getValue().asString());
                            }
                        }
                        AppConfigurationEntry entry3 = new AppConfigurationEntry(code, controlFlag2, options3);
                        holder.addAppConfigurationEntry(entry3);
                    }
                }
            }
            ModelNode authModuleNode = node.get("auth-module");
            List authModules = authModuleNode.asList();
            for (ModelNode authModule : authModules) {
                String code = authModule.require("code").asString();
                String loginStackRef = null;
                if (authModule.hasDefined("login-module-stack-ref")) {
                    loginStackRef = authModule.get("login-module-stack-ref").asString();
                }
                HashMap<String, String> options4 = new HashMap<String, String>();
                if (authModule.hasDefined("module-options")) {
                    for (Property prop : authModule.get("module-options").asPropertyList()) {
                        options4.put(prop.getName(), prop.getValue().asString());
                    }
                }
                AuthModuleEntry entry4 = new AuthModuleEntry(code, options4, loginStackRef);
                if (loginStackRef != null) {
                    if (!holders.containsKey(loginStackRef)) {
                        throw new IllegalArgumentException("auth-module references a login module stack that doesn't exist: " + loginStackRef);
                    }
                    entry4.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(loginStackRef));
                }
                authenticationInfo.add(entry4);
            }
            applicationPolicy.setAuthenticationInfo((BaseAuthenticationInfo)authenticationInfo);
        }
        return applicationPolicy;
    }

    private JSSESecurityDomain createJSSESecurityDomain(String securityDomain, ModelNode operation) {
        JBossJSSESecurityDomain jsseSecurityDomain = null;
        ModelNode node = operation.get("jsse");
        if (node.isDefined()) {
            jsseSecurityDomain = new JBossJSSESecurityDomain(securityDomain);
            String value = null;
            if (node.hasDefined("keystore-password")) {
                value = node.get("keystore-password").asString();
                try {
                    jsseSecurityDomain.setKeyStorePassword(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (node.hasDefined("keystore-type")) {
                value = node.get("keystore-type").asString();
                jsseSecurityDomain.setKeyStoreType(value);
            }
            if (node.hasDefined("keystore-url")) {
                value = node.get("keystore-url").asString();
                try {
                    jsseSecurityDomain.setKeyStoreURL(value);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe);
                }
            }
            if (node.hasDefined("keystore-provider")) {
                value = node.get("keystore-provider").asString();
                jsseSecurityDomain.setKeyStoreProvider(value);
            }
            if (node.hasDefined("keystore-provider-argument")) {
                value = node.get("keystore-provider-argument").asString();
                jsseSecurityDomain.setKeyStoreProviderArgument(value);
            }
            if (node.hasDefined("key-manager-factory-provider")) {
                value = node.get("key-manager-factory-provider").asString();
                jsseSecurityDomain.setKeyManagerFactoryProvider(value);
            }
            if (node.hasDefined("key-manager-factory-algorithm")) {
                value = node.get("key-manager-factory-algorithm").asString();
                jsseSecurityDomain.setKeyManagerFactoryAlgorithm(value);
            }
            if (node.hasDefined("truststore-password")) {
                value = node.get("truststore-password").asString();
                try {
                    jsseSecurityDomain.setTrustStorePassword(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (node.hasDefined("truststore-type")) {
                value = node.get("truststore-type").asString();
                jsseSecurityDomain.setTrustStoreType(value);
            }
            if (node.hasDefined("truststore-url")) {
                value = node.get("truststore-url").asString();
                try {
                    jsseSecurityDomain.setTrustStoreURL(value);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException(ioe);
                }
            }
            if (node.hasDefined("truststore-provider")) {
                value = node.get("truststore-provider").asString();
                jsseSecurityDomain.setTrustStoreProvider(value);
            }
            if (node.hasDefined("truststore-provider-argument")) {
                value = node.get("truststore-provider-argument").asString();
                jsseSecurityDomain.setTrustStoreProviderArgument(value);
            }
            if (node.hasDefined("trust-manager-factory-provider")) {
                value = node.get("trust-manager-factory-provider").asString();
                jsseSecurityDomain.setTrustManagerFactoryProvider(value);
            }
            if (node.hasDefined("trust-manager-factory-algorithm")) {
                value = node.get("trust-manager-factory-algorithm").asString();
                jsseSecurityDomain.setTrustManagerFactoryAlgorithm(value);
            }
            if (node.hasDefined("client-alias")) {
                value = node.get("client-alias").asString();
                jsseSecurityDomain.setClientAlias(value);
            }
            if (node.hasDefined("server-alias")) {
                value = node.get("server-alias").asString();
                jsseSecurityDomain.setServerAlias(value);
            }
            if (node.hasDefined("client-auth")) {
                boolean clientAuth = node.get("client-auth").asBoolean();
                jsseSecurityDomain.setClientAuth(clientAuth);
            }
            if (node.hasDefined("service-auth-token")) {
                value = node.get("service-auth-token").asString();
                try {
                    jsseSecurityDomain.setServiceAuthToken(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (node.hasDefined("cipher-suites")) {
                value = node.get("cipher-suites").asString();
                jsseSecurityDomain.setCipherSuites(value);
            }
            if (node.hasDefined("protocols")) {
                value = node.get("protocols").asString();
                jsseSecurityDomain.setProtocols(value);
            }
            if (node.hasDefined("additional-properties")) {
                value = node.get("additional-properties").asString();
                value = value.replaceAll("\\r", "").replaceAll("\\n", "").replaceAll("\\t", "");
                String[] entries = value.split(";");
                Properties properties = new Properties();
                for (int i = 0; i < entries.length; ++i) {
                    String tmp = entries[i];
                    tmp = tmp.replaceAll("^\\s+", "");
                    String[] entry = tmp.split("=");
                    properties.put(entry[0], entry[1]);
                }
                jsseSecurityDomain.setAdditionalProperties(properties);
            }
        }
        return jsseSecurityDomain;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new RuntimeException(flag + " is not recognized");
    }

    private String getAuthenticationCacheType(ModelNode operation) {
        String type = null;
        if (operation.hasDefined("cache-type")) {
            type = operation.get("cache-type").asString();
        }
        return type;
    }
}

