/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;
import org.jboss.wsf.stack.cxf.metadata.MetadataBuilder;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;

public class DescriptorDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DescriptorDeploymentAspect.class);
    private static final Logger log = Logger.getLogger(DescriptorDeploymentAspect.class);

    public void start(Deployment dep) {
        if (SpringUtils.isSpringAvailable((ClassLoader[])new ClassLoader[0])) {
            URL cxfURL = this.getCXFConfigFromDeployment(dep);
            if (cxfURL == null) {
                cxfURL = this.generateCXFConfigFromDeployment(dep);
            }
            this.putCXFConfigToDeployment(dep, cxfURL);
        } else {
            log.info((Object)"Spring not available, skipping check for user provided jbossws-cxf.xml / cxf.xml configuration files.");
            this.generateMetadataFromDeployment(dep);
        }
    }

    public void stop(Deployment dep) {
        DDBeans dd = (DDBeans)dep.getAttachment(DDBeans.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private URL getCXFConfigFromDeployment(Deployment dep) {
        String metadir;
        Deployment.DeploymentType depType = dep.getType();
        if (depType == Deployment.DeploymentType.JAXWS_EJB3) {
            metadir = "META-INF";
        } else if (depType == Deployment.DeploymentType.JAXWS_JSE) {
            metadir = "WEB-INF";
        } else {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_DEPLOYMENT_TYPE", (Object[])new Object[]{depType}));
        }
        URL cxfURL = null;
        try {
            ArchiveDeployment archDep = (ArchiveDeployment)dep;
            cxfURL = archDep.getResourceResolver().resolve(metadir + "/jbossws-cxf.xml");
            log.info((Object)("JBossWS-CXF configuration found: " + cxfURL));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return cxfURL;
    }

    private URL generateCXFConfigFromDeployment(Deployment dep) {
        DDBeans dd = this.generateMetadataFromDeployment(dep);
        URL cxfURL = dd.createFileURL();
        log.info((Object)("JBossWS-CXF configuration generated: " + cxfURL));
        return cxfURL;
    }

    private DDBeans generateMetadataFromDeployment(Deployment dep) {
        MetadataBuilder builder = new MetadataBuilder();
        DDBeans dd = builder.build(dep);
        dep.addAttachment(DDBeans.class, (Object)dd);
        return dd;
    }

    private void putCXFConfigToDeployment(Deployment dep, URL cxfURL) {
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty("stack.context.parameters");
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty("stack.context.parameters", contextParams);
        }
        contextParams.put("jbossws.cxf.beans.url", cxfURL.toExternalForm());
    }
}

