/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;

public class LargeServerMessageImpl
extends ServerMessageImpl
implements LargeServerMessage {
    private static final Logger log = Logger.getLogger(LargeServerMessageImpl.class);
    private static boolean isTrace = log.isTraceEnabled();
    private final JournalStorageManager storageManager;
    private LargeServerMessage linkMessage;
    private boolean paged;
    private SequentialFile file;
    private long bodySize = -1L;
    private final AtomicInteger delayDeletionCount = new AtomicInteger(0);
    private volatile int memoryEstimate = -1;

    public LargeServerMessageImpl(JournalStorageManager storageManager) {
        this.storageManager = storageManager;
    }

    private LargeServerMessageImpl(LargeServerMessageImpl copy, SequentialFile fileCopy, long newID) {
        super(copy);
        this.linkMessage = copy;
        this.storageManager = copy.storageManager;
        this.file = fileCopy;
        this.bodySize = copy.bodySize;
        this.setMessageID(newID);
    }

    @Override
    public void setPaged() {
        this.paged = true;
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)bytes.length;
    }

    public void encodeBody(HornetQBuffer bufferOut, BodyEncoder context, int size) {
        try {
            ByteBuffer bufferRead = ByteBuffer.allocate(size);
            int bytesRead = context.encode(bufferRead);
            bufferRead.flip();
            if (bytesRead > 0) {
                bufferOut.writeBytes(bufferRead.array(), 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    @Override
    public void encode(HornetQBuffer buffer) {
        super.encodeHeadersAndProperties(buffer);
    }

    @Override
    public void decode(HornetQBuffer buffer) {
        this.file = null;
        super.decodeHeadersAndProperties(buffer);
    }

    @Override
    public synchronized void incrementDelayDeletionCount() {
        this.delayDeletionCount.incrementAndGet();
    }

    @Override
    public synchronized void decrementDelayDeletionCount() throws Exception {
        int count = this.delayDeletionCount.decrementAndGet();
        if (count == 0) {
            this.checkDelete();
        }
    }

    @Override
    public BodyEncoder getBodyEncoder() throws HornetQException {
        this.validateFile();
        return new DecodingContext();
    }

    private void checkDelete() throws Exception {
        if (this.getRefCount() <= 0) {
            if (this.linkMessage != null) {
                this.linkMessage.decrementDelayDeletionCount();
            } else {
                if (isTrace) {
                    log.trace("Deleting file " + this.file + " as the usage was complete");
                }
                try {
                    this.deleteFile();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public synchronized int decrementRefCount() throws Exception {
        int currentRefCount = super.decrementRefCount();
        if (this.delayDeletionCount.get() <= 0) {
            this.checkDelete();
        }
        return currentRefCount;
    }

    @Override
    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.validateFile();
        this.releaseResources();
        this.storageManager.deleteFile(this.file);
    }

    @Override
    public boolean isFileExists() throws Exception {
        SequentialFile localfile = this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
        return localfile.exists();
    }

    @Override
    public synchronized int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
        }
        return this.memoryEstimate;
    }

    @Override
    public synchronized void releaseResources() {
        if (this.file != null && this.file.isOpen()) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public void setOriginalHeaders(ServerMessage other, boolean expiry) {
        super.setOriginalHeaders(other, expiry);
        LargeServerMessageImpl otherLM = (LargeServerMessageImpl)other;
        this.paged = otherLM.paged;
        if (this.paged) {
            this.removeProperty(Message.HDR_ORIG_MESSAGE_ID);
        }
    }

    @Override
    public synchronized ServerMessage copy(long newID) {
        if (!this.paged) {
            this.incrementDelayDeletionCount();
            long idToUse = this.messageID;
            if (this.linkMessage != null) {
                idToUse = this.linkMessage.getMessageID();
            }
            SequentialFile newfile = this.storageManager.createFileForLargeMessage(idToUse, this.durable);
            LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this.linkMessage == null ? this : (LargeServerMessageImpl)this.linkMessage, newfile, newID);
            return newMessage;
        }
        try {
            this.validateFile();
            SequentialFile file = this.file;
            SequentialFile newFile = this.storageManager.createFileForLargeMessage(newID, this.durable);
            file.copyTo(newFile);
            LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, newFile, newID);
            newMessage.linkMessage = null;
            newMessage.setPaged();
            return newMessage;
        }
        catch (Exception e) {
            log.warn("Error on copying large message this for DLA or Expiry", e);
            return null;
        }
    }

    public SequentialFile getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return "ServerMessage[messageID=" + this.messageID + ",priority=" + this.getPriority() + ",expiration=[" + (this.getExpiration() != 0L ? new Date(this.getExpiration()) : "null") + "]" + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]";
    }

    protected void finalize() throws Throwable {
        this.releaseResources();
        super.finalize();
    }

    private synchronized void validateFile() throws HornetQException {
        try {
            if (this.file == null) {
                if (this.messageID <= 0L) {
                    throw new RuntimeException("MessageID not set on LargeMessage");
                }
                this.file = this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
                this.file.open();
                this.bodySize = this.file.size();
            }
        }
        catch (Exception e) {
            throw new HornetQException(0, e.getMessage(), e);
        }
    }

    @Override
    public void setLinkedMessage(LargeServerMessage message) {
        if (this.file != null) {
            throw new IllegalStateException("LargeMessage file was already set");
        }
        this.linkMessage = message;
        this.file = this.storageManager.createFileForLargeMessage(message.getMessageID(), this.durable);
        try {
            this.file.open();
            this.bodySize = this.file.size();
            this.file.close();
        }
        catch (Exception e) {
            throw new RuntimeException("could not setup linked file", e);
        }
    }

    class DecodingContext
    implements BodyEncoder {
        private SequentialFile cFile;

        DecodingContext() {
        }

        @Override
        public void open() throws HornetQException {
            try {
                this.cFile = LargeServerMessageImpl.this.file.copy();
                this.cFile.open();
            }
            catch (Exception e) {
                throw new HornetQException(0, e.getMessage(), e);
            }
        }

        @Override
        public void close() throws HornetQException {
            try {
                this.cFile.close();
            }
            catch (Exception e) {
                throw new HornetQException(0, e.getMessage(), e);
            }
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws HornetQException {
            try {
                return this.cFile.read(bufferRead);
            }
            catch (Exception e) {
                throw new HornetQException(0, e.getMessage(), e);
            }
        }

        @Override
        public int encode(HornetQBuffer bufferOut, int size) throws HornetQException {
            ByteBuffer bufferRead = ByteBuffer.allocate(size);
            int bytesRead = this.encode(bufferRead);
            bufferRead.flip();
            if (bytesRead > 0) {
                bufferOut.writeBytes(bufferRead.array(), 0, bytesRead);
            }
            return bytesRead;
        }

        @Override
        public long getLargeBodySize() {
            return LargeServerMessageImpl.this.bodySize;
        }
    }
}

