/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services;

import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.services.bootstrap.WeldResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldSecurityServices;
import org.jboss.as.weld.services.bootstrap.WeldTransactionServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;

public class WeldService
implements Service<WeldContainer> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldService"});
    private final WeldContainer weldContainer;
    private final InjectedValue<WeldResourceInjectionServices> resourceInjectionServices = new InjectedValue();
    private final InjectedValue<WeldSecurityServices> securityServices = new InjectedValue();
    private final InjectedValue<WeldTransactionServices> weldTransactionServices = new InjectedValue();

    public WeldService(WeldContainer weldContainer) {
        this.weldContainer = weldContainer;
    }

    public void start(StartContext context) throws StartException {
        try {
            log.info((Object)"Starting weld service");
            this.weldContainer.addWeldService(SecurityServices.class, (org.jboss.weld.bootstrap.api.Service)this.securityServices.getValue());
            this.weldContainer.addWeldService(TransactionServices.class, (org.jboss.weld.bootstrap.api.Service)this.weldTransactionServices.getValue());
            for (BeanDeploymentArchive bda : this.weldContainer.getBeanDeploymentArchives()) {
                bda.getServices().add(ResourceInjectionServices.class, (org.jboss.weld.bootstrap.api.Service)this.resourceInjectionServices.getValue());
            }
            this.weldContainer.start();
        }
        catch (Exception e) {
            try {
                this.weldContainer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        log.info((Object)"Stopping weld service");
        this.weldContainer.stop();
    }

    public WeldContainer getValue() throws IllegalStateException {
        return this.weldContainer;
    }

    public InjectedValue<WeldTransactionServices> getWeldTransactionServices() {
        return this.weldTransactionServices;
    }

    public InjectedValue<WeldResourceInjectionServices> getResourceInjectionServices() {
        return this.resourceInjectionServices;
    }

    public InjectedValue<WeldSecurityServices> getSecurityServices() {
        return this.securityServices;
    }
}

