/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.jacorb.JacORBAttribute;
import org.jboss.as.jacorb.JacORBElement;
import org.jboss.as.jacorb.JacORBNamespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JacORBSubsystemDescriptions {
    static final String RESOURCE_NAME = JacORBSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystem(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return Descriptions.getSubsystemAdd(locale);
        }
    };
    static final DescriptionProvider SUBSYSTEM_DESCRIBE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    };

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    private static class Descriptions {
        private Descriptions() {
        }

        static ModelNode getSubsystem(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("jacorb"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(JacORBNamespace.CURRENT.getUriString());
            subsystem.get(new String[]{"children", JacORBElement.ORB_CONFIG.getLocalName()}).set(Descriptions.getORBConfiguration(locale));
            subsystem.get(new String[]{"children", JacORBElement.POA_CONFIG.getLocalName()}).set(Descriptions.getPOAConfiguration(locale));
            subsystem.get(new String[]{"children", JacORBElement.INTEROP_CONFIG.getLocalName()}).set(Descriptions.getInteropConfiguration(locale));
            subsystem.get(new String[]{"children", JacORBElement.SECURITY_CONFIG.getLocalName()}).set(Descriptions.getSecurityConfiguration(locale));
            subsystem.get(new String[]{"children", JacORBElement.PROPERTY_CONFIG.getLocalName()}).set(Descriptions.getPropertyConfiguration(locale));
            subsystem.get(new String[]{"children", JacORBElement.INITIALIZERS_CONFIG.getLocalName()}).set(Descriptions.getInitializersConfiguration(locale));
            return subsystem;
        }

        static ModelNode getORBConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAME.getLocalName(), "description"}).set(bundle.getString("orb.config.name"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAME.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAME.getLocalName(), "default"}).set("JBoss");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "description"}).set(bundle.getString("orb.config.print-version"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_IMR.getLocalName(), "description"}).set(bundle.getString("orb.config.use-imr"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_IMR.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_IMR.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_IMR.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_BOM.getLocalName(), "description"}).set(bundle.getString("orb.config.use-bom"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_BOM.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_BOM.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_USE_BOM.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "description"}).set(bundle.getString("orb.config.cache-typecodes"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "description"}).set(bundle.getString("orb.config.cache-poa-names"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "description"}).set(bundle.getString("orb.config.giop-minor-version"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "default"}).set(2);
            node.get(new String[]{"children", JacORBElement.ORB_CONNECTION_CONFIG.getLocalName()}).set(Descriptions.getORBConnectionConfiguration(locale));
            node.get(new String[]{"children", JacORBElement.ORB_NAMING_CONFIG.getLocalName()}).set(Descriptions.getORBNamingConfiguration(locale));
            return node;
        }

        static ModelNode getORBConnectionConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.conn.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.retries"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "default"}).set(5);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.retry-interval"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "default"}).set(500);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.client-timeout"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "default"}).set(0);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.server-timeout"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "default"}).set(0);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.max-server-connections"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "default"}).set(Integer.MAX_VALUE);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.max-managed-buf-size"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "default"}).set(24);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.outbuf-size"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "default"}).set(2048);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.outbuf-cache-timeout"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "default"}).set(-1);
            return node;
        }

        static ModelNode getORBNamingConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.naming.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "description"}).set(bundle.getString("orb.naming.config.root-context"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "default"}).set("JBoss/Naming/root");
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "description"}).set(bundle.getString("orb.naming.config.export-corbaloc"));
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "default"}).set("on");
            return node;
        }

        static ModelNode getPOAConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("poa.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.POA_MONITORING.getLocalName(), "description"}).set(bundle.getString("poa.config.monitoring"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_MONITORING.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.POA_MONITORING.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.POA_MONITORING.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-wait"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-min"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "default"}).set(10);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-max"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "default"}).set(100);
            node.get(JacORBElement.POA_REQUEST_PROC_CONFIG.getLocalName()).set(Descriptions.getPOARequestProcessorsConfiguration(locale));
            return node;
        }

        static ModelNode getPOARequestProcessorsConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("poa.request-processors.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "description"}).set(bundle.getString("poa.request-processors.config.pool-size"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "default"}).set(5);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "description"}).set(bundle.getString("poa.request-processors.config.max-threads"));
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "default"}).set(20);
            return node;
        }

        static ModelNode getInteropConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("interop.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_SUN.getLocalName(), "description"}).set(bundle.getString("interop.config.sun"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_SUN.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_SUN.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_SUN.getLocalName(), "default"}).set("on");
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_COMET.getLocalName(), "description"}).set(bundle.getString("interop.config.comet"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_COMET.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_COMET.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_COMET.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "description"}).set(bundle.getString("interop.config.chunk-custom-rmi-valuetypes"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "default"}).set("on");
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "description"}).set(bundle.getString("interop.config.lax-boolean-encoding"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "description"}).set(bundle.getString("interop.config.indirection-encoding-disable"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "description"}).set(bundle.getString("interop.config.strict-check-on-tc-creation"));
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "default"}).set("off");
            return node;
        }

        static ModelNode getSecurityConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("security.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "description"}).set(bundle.getString("security.config.support-ssl"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "description"}).set(bundle.getString("security.config.add-component-via-interceptor"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "default"}).set("on");
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "description"}).set(bundle.getString("security.config.client-supports"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "default"}).set(60);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "description"}).set(bundle.getString("security.config.client-requires"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "default"}).set(0);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "description"}).set(bundle.getString("security.config.server-supports"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "default"}).set(60);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "description"}).set(bundle.getString("security.config.server-requires"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "default"}).set(0);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "description"}).set(bundle.getString("security.config.use-domain-socket-factory"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "default"}).set("off");
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "description"}).set(bundle.getString("security.config.use-domain-server-socket-factory"));
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "required"}).set(false);
            node.get(new String[]{"attributes", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "default"}).set("off");
            return node;
        }

        static ModelNode getPropertyConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("property.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(Integer.MAX_VALUE);
            node.get(new String[]{"attributes", JacORBAttribute.PROP_KEY.getLocalName(), "description"}).set(bundle.getString("property.config.key"));
            node.get(new String[]{"attributes", JacORBAttribute.PROP_KEY.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.PROP_KEY.getLocalName(), "required"}).set(true);
            node.get(new String[]{"attributes", JacORBAttribute.PROP_VALUE.getLocalName(), "description"}).set(bundle.getString("property.config.value"));
            node.get(new String[]{"attributes", JacORBAttribute.PROP_VALUE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", JacORBAttribute.PROP_VALUE.getLocalName(), "required"}).set(true);
            return node;
        }

        static ModelNode getInitializersConfiguration(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.STRING);
            node.get("description").set(bundle.getString("initializers.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get("default").set("Codebase,CSIv2,SAS");
            return node;
        }

        static ModelNode getSubsystemAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add");
            op.get("description").set(bundle.getString("jacorb.add"));
            op.get(new String[]{"children", JacORBElement.ORB_CONFIG.getLocalName()}).set(Descriptions.getORBConfigurationAdd(locale));
            op.get(new String[]{"children", JacORBElement.POA_CONFIG.getLocalName()}).set(Descriptions.getPOAConfigurationAdd(locale));
            op.get(new String[]{"children", JacORBElement.INTEROP_CONFIG.getLocalName()}).set(Descriptions.getInteropConfigurationAdd(locale));
            op.get(new String[]{"children", JacORBElement.SECURITY_CONFIG.getLocalName()}).set(Descriptions.getSecurityConfigurationAdd(locale));
            op.get(new String[]{"children", JacORBElement.PROPERTY_CONFIG.getLocalName()}).set(Descriptions.getPropertyConfigurationAdd(locale));
            op.get(new String[]{"children", JacORBElement.INITIALIZERS_CONFIG.getLocalName()}).set(Descriptions.getInitializersConfiguration(locale));
            op.get("reply-properties").setEmptyObject();
            return op;
        }

        static ModelNode getORBConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAME.getLocalName(), "description"}).set(bundle.getString("orb.config.name"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAME.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAME.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAME.getLocalName(), "default"}).set("JBoss");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "description"}).set(bundle.getString("orb.config.print-version"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_PRINT_VERSION.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_IMR.getLocalName(), "description"}).set(bundle.getString("orb.config.use-imr"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_IMR.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_IMR.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_IMR.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_BOM.getLocalName(), "description"}).set(bundle.getString("orb.config.use-bom"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_BOM.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_BOM.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_USE_BOM.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "description"}).set(bundle.getString("orb.config.cache-typecodes"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_TYPECODES.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "description"}).set(bundle.getString("orb.config.cache-poa-names"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CACHE_POA_NAMES.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "description"}).set(bundle.getString("orb.config.giop-minor-version"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_GIOP_MINOR_VERSION.getLocalName(), "default"}).set(2);
            node.get(new String[]{"children", JacORBElement.ORB_CONNECTION_CONFIG.getLocalName()}).set(Descriptions.getORBConnectionConfigurationAdd(locale));
            node.get(new String[]{"children", JacORBElement.ORB_NAMING_CONFIG.getLocalName()}).set(Descriptions.getORBNamingConfigurationAdd(locale));
            return node;
        }

        static ModelNode getORBConnectionConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.conn.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.retries"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRIES.getLocalName(), "default"}).set(5);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.retry-interval"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_RETRY_INTERVAL.getLocalName(), "default"}).set(500);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.client-timeout"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_CLIENT_TIMEOUT.getLocalName(), "default"}).set(0);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.server-timeout"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_SERVER_TIMEOUT.getLocalName(), "default"}).set(0);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.max-server-connections"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_SERVER_CONNECTIONS.getLocalName(), "default"}).set(Integer.MAX_VALUE);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.max-managed-buf-size"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_MAX_MANAGED_BUF_SIZE.getLocalName(), "default"}).set(24);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.outbuf-size"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_SIZE.getLocalName(), "default"}).set(2048);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "description"}).set(bundle.getString("orb.conn.config.outbuf-cache-timeout"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_CONN_OUTBUF_CACHE_TIMEOUT.getLocalName(), "default"}).set(-1);
            return node;
        }

        static ModelNode getORBNamingConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("orb.naming.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "description"}).set(bundle.getString("orb.naming.config.root-context"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_ROOT_CONTEXT.getLocalName(), "default"}).set("JBoss/Naming/root");
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "description"}).set(bundle.getString("orb.naming.config.export-corbaloc"));
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.ORB_NAMING_EXPORT_CORBALOC.getLocalName(), "default"}).set("on");
            return node;
        }

        static ModelNode getPOAConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("poa.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_MONITORING.getLocalName(), "description"}).set(bundle.getString("poa.config.monitoring"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_MONITORING.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_MONITORING.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_MONITORING.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-wait"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_WAIT.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-min"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MIN.getLocalName(), "default"}).set(10);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "description"}).set(bundle.getString("poa.config.queue-max"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_QUEUE_MAX.getLocalName(), "default"}).set(100);
            node.get(JacORBElement.POA_REQUEST_PROC_CONFIG.getLocalName()).set(Descriptions.getPOAThreadPoolConfigurationAdd(locale));
            return node;
        }

        static ModelNode getPOAThreadPoolConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("poa.request-processors.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "description"}).set(bundle.getString("poa.request-processors.config.pool-size"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_POOL_SIZE.getLocalName(), "default"}).set(5);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "description"}).set(bundle.getString("poa.request-processors.config.max-threads"));
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", JacORBAttribute.POA_REQUEST_PROC_MAX_THREADS.getLocalName(), "default"}).set(20);
            return node;
        }

        static ModelNode getInteropConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("interop.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_SUN.getLocalName(), "description"}).set(bundle.getString("interop.config.sun"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_SUN.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_SUN.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_SUN.getLocalName(), "default"}).set("on");
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_COMET.getLocalName(), "description"}).set(bundle.getString("interop.config.comet"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_COMET.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_COMET.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_COMET.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "description"}).set(bundle.getString("interop.config.chunk-custom-rmi-valuetypes"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_CHUNK_RMI_VALUETYPES.getLocalName(), "default"}).set("on");
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "description"}).set(bundle.getString("interop.config.lax-boolean-encoding"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_LAX_BOOLEAN_ENCODING.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "description"}).set(bundle.getString("interop.config.indirection-encoding-disable"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_INDIRECTION_ENCODING_DISABLE.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "description"}).set(bundle.getString("interop.config.strict-check-on-tc-creation"));
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.INTEROP_STRICT_CHECK_ON_TC_CREATION.getLocalName(), "default"}).set("off");
            return node;
        }

        static ModelNode getSecurityConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.OBJECT);
            node.get("description").set(bundle.getString("security.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(1);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "description"}).set(bundle.getString("security.config.support-ssl"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SUPPORT_SSL.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "description"}).set(bundle.getString("security.config.add-component-via-interceptor"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_ADD_COMPONENT_INTERCEPTOR.getLocalName(), "default"}).set("on");
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "description"}).set(bundle.getString("security.config.client-supports"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_SUPPORTS.getLocalName(), "default"}).set(60);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "description"}).set(bundle.getString("security.config.client-requires"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_CLIENT_REQUIRES.getLocalName(), "default"}).set(0);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "description"}).set(bundle.getString("security.config.server-supports"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_SUPPORTS.getLocalName(), "default"}).set(60);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "description"}).set(bundle.getString("security.config.server-requires"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "type"}).set(ModelType.INT);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_SERVER_REQUIRES.getLocalName(), "default"}).set(0);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "description"}).set(bundle.getString("security.config.use-domain-socket-factory"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SF.getLocalName(), "default"}).set("off");
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "description"}).set(bundle.getString("security.config.use-domain-server-socket-factory"));
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "required"}).set(false);
            node.get(new String[]{"request-properties", JacORBAttribute.SECURITY_USE_DOMAIN_SSF.getLocalName(), "default"}).set("off");
            return node;
        }

        static ModelNode getPropertyConfigurationAdd(Locale locale) {
            ResourceBundle bundle = JacORBSubsystemDescriptions.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("type").set(ModelType.LIST);
            node.get("description").set(bundle.getString("property.config"));
            node.get("required").set(false);
            node.get("min-occurs").set(0);
            node.get("max-occurs").set(Integer.MAX_VALUE);
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_KEY.getLocalName(), "description"}).set(bundle.getString("property.config.key"));
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_KEY.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_KEY.getLocalName(), "required"}).set(true);
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_VALUE.getLocalName(), "description"}).set(bundle.getString("property.config.value"));
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_VALUE.getLocalName(), "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", JacORBAttribute.PROP_VALUE.getLocalName(), "required"}).set(true);
            return node;
        }
    }
}

