/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashMap;
import java.util.Map;

enum JacORBNamespace {
    UNKNOWN(null),
    JacORB_1_0("urn:jboss:domain:jacorb:1.0");

    static final JacORBNamespace CURRENT;
    private final String namespaceURI;
    private static final Map<String, JacORBNamespace> MAP;

    private JacORBNamespace(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    String getUriString() {
        return this.namespaceURI;
    }

    static JacORBNamespace forUri(String uri) {
        JacORBNamespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = JacORB_1_0;
        HashMap<String, JacORBNamespace> map = new HashMap<String, JacORBNamespace>();
        for (JacORBNamespace namespace : JacORBNamespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

