/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DataSourceDisable
implements OperationStepHandler {
    static final DataSourceDisable INSTANCE = new DataSourceDisable();
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public void execute(OperationContext context, ModelNode operation) {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        model.get("enabled").set(false);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName binderServiceName;
                    ServiceController binderController;
                    ServiceName dataSourceServiceName;
                    String jndiName = Util.getJndiName(model);
                    ServiceRegistry registry = context.getServiceRegistry(true);
                    ServiceController dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}));
                    if (dataSourceController != null) {
                        if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                            throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is not enabled"));
                        }
                    } else {
                        throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is not available"));
                    }
                    dataSourceController.setMode(ServiceController.Mode.NEVER);
                    ServiceName referenceServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceController referenceController = registry.getService(referenceServiceName);
                    if (referenceController != null && ServiceController.State.UP.equals((Object)referenceController.getState())) {
                        referenceController.setMode(ServiceController.Mode.NEVER);
                    }
                    if ((binderController = registry.getService(binderServiceName = ContextNames.bindInfoFor((String)jndiName).getBinderServiceName())) != null && ServiceController.State.UP.equals((Object)binderController.getState())) {
                        binderController.setMode(ServiceController.Mode.NEVER);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

