/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.context.NamespaceContextSelector;

public class InitialContext
extends NamingContext {
    public InitialContext(Hashtable<String, Object> environment) {
        super(environment);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.lookup(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.lookup(parsedName.remaining());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.listBindings(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.listBindings(parsedName.remaining());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        ParsedName parsedName = this.parse(name);
        if (parsedName.namespace() == null || parsedName.namespace().equals("")) {
            return super.list(parsedName.remaining());
        }
        NamespaceContextSelector selector = NamespaceContextSelector.getCurrentSelector();
        if (selector == null) {
            throw new NameNotFoundException(name.toString());
        }
        Context namespaceContext = selector.getContext(parsedName.namespace());
        if (namespaceContext == null) {
            throw new NameNotFoundException(name.toString());
        }
        return namespaceContext.list(parsedName.remaining());
    }

    private ParsedName parse(Name name) throws NamingException {
        Name remaining;
        String namespace;
        if (name.isEmpty()) {
            namespace = null;
            remaining = name;
        } else {
            String first = name.get(0);
            if (first.startsWith("java:")) {
                String theRest = first.substring(5);
                if (theRest.startsWith("/")) {
                    namespace = null;
                    remaining = this.getNameParser(theRest).parse(theRest);
                } else {
                    namespace = theRest;
                    remaining = name.getSuffix(1);
                }
            } else {
                namespace = null;
                remaining = name;
            }
        }
        return new ParsedName(){

            @Override
            public String namespace() {
                return namespace;
            }

            @Override
            public Name remaining() {
                return remaining;
            }
        };
    }

    private static interface ParsedName {
        public String namespace();

        public Name remaining();
    }
}

