/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.services.ResourceAdapterActivatorService;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.messaging.jms.PooledConnectionFactoryConfigProperties;
import org.jboss.as.messaging.jms.TransactionManagerLocator;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.txn.TxnServices;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.CredentialInterfaceEnum;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.Messageadapter;
import org.jboss.jca.common.api.metadata.ra.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra15.Activationspec15;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonConnDefImpl;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ironjacamar.IronJacamarImpl;
import org.jboss.jca.common.metadata.ra.common.AuthenticationMechanismImpl;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.ra.common.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.ra.common.InboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.MessageListenerImpl;
import org.jboss.jca.common.metadata.ra.common.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.ResourceAdapter1516Impl;
import org.jboss.jca.common.metadata.ra.ra16.Activationspec16Impl;
import org.jboss.jca.common.metadata.ra.ra16.ConfigProperty16Impl;
import org.jboss.jca.common.metadata.ra.ra16.Connector16Impl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public class PooledConnectionFactoryService
implements Service<Void> {
    private static final List<LocalizedXsdString> EMPTY_LOCL = Collections.emptyList();
    private static final String CONNECTOR_CLASSNAME = "ConnectorClassName";
    private static final String CONNECTION_PARAMETERS = "ConnectionParameters";
    private static final String HQ_ACTIVIATION = "org.hornetq.ra.inflow.HornetQActivationSpec";
    private static final String HQ_CONN_DEF = "HornetQConnectionDefinition";
    private static final String HQ_ADAPTER = "org.hornetq.ra.HornetQResourceAdapter";
    private static final String RAMANAGED_CONN_FACTORY = "org.hornetq.ra.HornetQRAManagedConnectionFactory";
    private static final String RA_CONN_FACTORY = "org.hornetq.ra.HornetQRAConnectionFactory";
    private static final String RA_CONN_FACTORY_IMPL = "org.hornetq.ra.HornetQRAConnectionFactoryImpl";
    private static final String JMS_SESSION = "javax.jms.Session";
    private static final String HQ_SESSION = "org.hornetq.ra.HornetQRASession";
    private static final String BASIC_PASS = "BasicPassword";
    private static final String JMS_QUEUE = "javax.jms.Queue";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String INTEGER_TYPE = "java.lang.Integer";
    private static final String SESSION_DEFAULT_TYPE = "SessionDefaultType";
    private static final String TRY_LOCK = "UseTryLock";
    private static final String JMS_MESSAGE_LISTENER = "javax.jms.MessageListener";
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.hornet");
    private static final Collection<String> JMS_ACTIVATION_CONFIG_PROPERTIES = new HashSet<String>();
    private Injector<Object> transactionManager;
    private List<String> connectors;
    private List<PooledConnectionFactoryConfigProperties> adapterParams;
    private String name;
    private Map<String, SocketBinding> socketBindings;
    private InjectedValue<HornetQServer> hornetQService;
    private String jndiName;
    private String txSupport;

    public PooledConnectionFactoryService(String name, List<String> connectors, List<PooledConnectionFactoryConfigProperties> adapterParams, String jndiName, String txSupport) {
        JMS_ACTIVATION_CONFIG_PROPERTIES.add("acknowledgeMode");
        JMS_ACTIVATION_CONFIG_PROPERTIES.add("destinationType");
        JMS_ACTIVATION_CONFIG_PROPERTIES.add("messageSelector");
        JMS_ACTIVATION_CONFIG_PROPERTIES.add("subscriptionDurability");
        this.transactionManager = new InjectedValue();
        this.socketBindings = new HashMap<String, SocketBinding>();
        this.hornetQService = new InjectedValue();
        this.name = name;
        this.connectors = connectors;
        this.adapterParams = adapterParams;
        this.jndiName = jndiName;
        this.txSupport = txSupport;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        ServiceTarget serviceTarget = context.getChildTarget();
        try {
            this.createService(serviceTarget, context.getController().getServiceContainer());
        }
        catch (Exception e) {
            throw new StartException("failed to create resource adapter", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createService(ServiceTarget serviceTarget, ServiceContainer container) throws Exception {
        InputStream is = null;
        InputStream isIj = null;
        ArrayList<ConfigProperty16> properties = new ArrayList<ConfigProperty16>();
        try {
            StringBuilder connectorClassname = new StringBuilder();
            StringBuilder connectorParams = new StringBuilder();
            for (String connector : this.connectors) {
                TransportConfiguration tc = (TransportConfiguration)((HornetQServer)this.hornetQService.getValue()).getConfiguration().getConnectorConfigurations().get(connector);
                if (tc == null) {
                    throw new IllegalStateException("connector " + connector + " not defined");
                }
                if (connectorClassname.length() > 0) {
                    connectorClassname.append(",");
                    connectorParams.append(",");
                }
                connectorClassname.append(tc.getFactoryClassName());
                Map params = tc.getParams();
                boolean multiple = false;
                for (Map.Entry entry : params.entrySet()) {
                    if (multiple) {
                        connectorParams.append(";");
                    }
                    connectorParams.append((String)entry.getKey()).append("=").append(entry.getValue());
                    multiple = true;
                }
            }
            if (connectorClassname.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty(CONNECTOR_CLASSNAME, STRING_TYPE, connectorClassname.toString()));
            }
            if (connectorParams.length() > 0) {
                properties.add(PooledConnectionFactoryService.simpleProperty(CONNECTION_PARAMETERS, STRING_TYPE, connectorParams.toString()));
            }
            for (PooledConnectionFactoryConfigProperties adapterParam : this.adapterParams) {
                properties.add(PooledConnectionFactoryService.simpleProperty(adapterParam.getName(), adapterParam.getType(), adapterParam.getValue()));
            }
            TransactionManagerLocator.container = container;
            properties.add(PooledConnectionFactoryService.simpleProperty("TransactionManagerLocatorClass", STRING_TYPE, TransactionManagerLocator.class.getName()));
            properties.add(PooledConnectionFactoryService.simpleProperty("TransactionManagerLocatorMethod", STRING_TYPE, "getTransactionManager"));
            OutboundResourceAdapter outbound = PooledConnectionFactoryService.createOutbound();
            InboundResourceAdapter inbound = this.createInbound();
            ResourceAdapter1516Impl ra = this.createResourceAdapter(properties, outbound, inbound);
            Connector16Impl cmd = PooledConnectionFactoryService.createConnector((ResourceAdapter1516)ra);
            CommonConnDef common = PooledConnectionFactoryService.createConnDef(this.jndiName);
            IronJacamarImpl ijmd = PooledConnectionFactoryService.createIron(common, this.txSupport);
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService((Connector)cmd, (IronJacamar)ijmd, PooledConnectionFactoryService.class.getClassLoader(), this.name);
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE, (Service)activator).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, activator.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector()).addDependency(NamingService.SERVICE_NAME).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER).setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.name}), Service.NULL).install();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isIj != null) {
                isIj.close();
            }
        }
    }

    private static IronJacamarImpl createIron(CommonConnDef common, String txSupport) {
        TransactionSupportEnum transactionSupport;
        try {
            transactionSupport = TransactionSupportEnum.valueOf((String)txSupport);
        }
        catch (RuntimeException e) {
            transactionSupport = TransactionSupportEnum.LocalTransaction;
        }
        List<CommonConnDef> definitions = Collections.singletonList(common);
        return new IronJacamarImpl(transactionSupport, Collections.emptyMap(), Collections.emptyList(), definitions, Collections.emptyList(), null);
    }

    private static CommonConnDef createConnDef(String jndiName) throws ValidateException {
        CommonPoolImpl pool = new CommonPoolImpl(null, null, Boolean.valueOf(false), Boolean.valueOf(false), FlushStrategy.FAILING_CONNECTION_ONLY);
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(null, null, null, null, null);
        CommonSecurity security = null;
        Recovery recovery = new Recovery((Credential)new CredentialImpl(null, null, null), null, Boolean.FALSE);
        CommonValidationImpl validation = new CommonValidationImpl(null, null, Boolean.valueOf(false));
        return new CommonConnDefImpl(Collections.emptyMap(), RAMANAGED_CONN_FACTORY, jndiName, HQ_CONN_DEF, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, security, recovery);
    }

    private static Connector16Impl createConnector(ResourceAdapter1516 ra) {
        return new Connector16Impl(null, PooledConnectionFactoryService.str("Red Hat"), PooledConnectionFactoryService.str("JMS 1.1 Server"), PooledConnectionFactoryService.str("1.0"), null, ra, Collections.emptyList(), false, EMPTY_LOCL, EMPTY_LOCL, Collections.emptyList(), null);
    }

    private ResourceAdapter1516Impl createResourceAdapter(List<ConfigProperty16> properties, OutboundResourceAdapter outbound, InboundResourceAdapter inbound) {
        return new ResourceAdapter1516Impl(HQ_ADAPTER, properties, outbound, inbound, Collections.emptyList(), Collections.emptyList(), null);
    }

    private InboundResourceAdapter createInbound() {
        List<RequiredConfigProperty> destination = Collections.singletonList(new RequiredConfigProperty(EMPTY_LOCL, PooledConnectionFactoryService.str("destination"), null));
        ArrayList<ConfigPropertyImpl> jmsActivationConfigProps = new ArrayList<ConfigPropertyImpl>(JMS_ACTIVATION_CONFIG_PROPERTIES.size());
        for (String activationConfigProp : JMS_ACTIVATION_CONFIG_PROPERTIES) {
            ConfigPropertyImpl configProp = new ConfigPropertyImpl(EMPTY_LOCL, PooledConnectionFactoryService.str(activationConfigProp), PooledConnectionFactoryService.str(STRING_TYPE), null, null);
            jmsActivationConfigProps.add(configProp);
        }
        Activationspec16Impl activation = new Activationspec16Impl(PooledConnectionFactoryService.str(HQ_ACTIVIATION), destination, jmsActivationConfigProps, null);
        List<MessageListenerImpl> messageListeners = Collections.singletonList(new MessageListenerImpl(PooledConnectionFactoryService.str(JMS_MESSAGE_LISTENER), (Activationspec15)activation, null));
        MessageAdapterImpl message = new MessageAdapterImpl(messageListeners, null);
        return new InboundResourceAdapterImpl((Messageadapter)message, null);
    }

    private static OutboundResourceAdapter createOutbound() {
        ArrayList<ConnectionDefinitionImpl> definitions = new ArrayList<ConnectionDefinitionImpl>();
        ArrayList<ConfigProperty16> props = new ArrayList<ConfigProperty16>();
        props.add(PooledConnectionFactoryService.simpleProperty(SESSION_DEFAULT_TYPE, STRING_TYPE, JMS_QUEUE));
        props.add(PooledConnectionFactoryService.simpleProperty(TRY_LOCK, INTEGER_TYPE, "0"));
        definitions.add(new ConnectionDefinitionImpl(PooledConnectionFactoryService.str(RAMANAGED_CONN_FACTORY), props, PooledConnectionFactoryService.str(RA_CONN_FACTORY), PooledConnectionFactoryService.str(RA_CONN_FACTORY_IMPL), PooledConnectionFactoryService.str(JMS_SESSION), PooledConnectionFactoryService.str(HQ_SESSION), null));
        AuthenticationMechanismImpl basicPassword = new AuthenticationMechanismImpl(Collections.emptyList(), PooledConnectionFactoryService.str(BASIC_PASS), CredentialInterfaceEnum.PasswordCredential, null);
        return new OutboundResourceAdapterImpl(definitions, TransactionSupportEnum.XATransaction, Collections.singletonList(basicPassword), false, null);
    }

    private static XsdString str(String str) {
        return new XsdString(str, null);
    }

    private static ConfigProperty16 simpleProperty(String name, String type, String value) {
        return new ConfigProperty16Impl(EMPTY_LOCL, PooledConnectionFactoryService.str(name), PooledConnectionFactoryService.str(type), PooledConnectionFactoryService.str(value), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null);
    }

    public void stop(StopContext context) {
    }

    public Injector<Object> getTransactionManager() {
        return this.transactionManager;
    }

    Injector<SocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    public Injector<HornetQServer> getHornetQService() {
        return this.hornetQService;
    }
}

