/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Map;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.naming.MockContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Values;

class ConnectionFactoryService
implements Service<Void> {
    private final String name;
    private final ConnectionFactoryConfiguration configuration;
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();

    public ConnectionFactoryService(ConnectionFactoryConfiguration configuration) {
        this.name = configuration.getName();
        if (this.name == null) {
            throw new IllegalArgumentException("null cf name");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            MockContext.pushBindingTrap();
            try {
                jmsManager.createConnectionFactory(false, this.configuration, this.configuration.getBindings());
            }
            finally {
                ServiceTarget target = context.getChildTarget();
                Map bindings = MockContext.popTrappedBindings();
                for (Map.Entry binding : bindings.entrySet()) {
                    ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)((String)binding.getKey()));
                    BinderService binderService = new BinderService(bindInfo.getBindName());
                    target.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), NamingStore.class, binderService.getNamingStoreInjector()).addInjection(binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue(binding.getValue()))).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
            }
        }
        catch (Exception e) {
            throw new StartException("failed to create connection-factory", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.destroyConnectionFactory(this.name);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy connection-factory: %s", (Object)this.name);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

