/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.FlowControl;
import org.jgroups.util.Util;

@MBean(description="Simple flow control protocol based on a credit system")
public class UFC
extends FlowControl {
    protected final Map<Address, FlowControl.Credit> sent = Util.createConcurrentMap();

    @Override
    @ManagedOperation(description="Print sender credits")
    public String printSenderCredits() {
        return UFC.printMap(this.sent);
    }

    @Override
    @ManagedOperation(description="Print credits")
    public String printCredits() {
        StringBuilder sb = new StringBuilder(super.printCredits());
        sb.append("\nsenders:\n").append(UFC.printMap(this.sent));
        return sb.toString();
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        retval.put("senders", UFC.printMap(this.sent));
        return retval;
    }

    @Override
    protected boolean handleMulticastMessage() {
        return false;
    }

    @Override
    public void unblock() {
        super.unblock();
    }

    @Override
    @ManagedAttribute(description="Number of times flow control blocks sender")
    public int getNumberOfBlockings() {
        int retval = 0;
        for (FlowControl.Credit cred : this.sent.values()) {
            retval += cred.getNumBlockings();
        }
        return retval;
    }

    @Override
    @ManagedAttribute(description="Total time (ms) spent in flow control block")
    public long getTotalTimeBlocked() {
        long retval = 0L;
        for (FlowControl.Credit cred : this.sent.values()) {
            retval += cred.getTotalBlockingTime();
        }
        return retval;
    }

    @Override
    public void stop() {
        super.stop();
        for (FlowControl.Credit cred : this.sent.values()) {
            cred.set(this.max_credits);
        }
    }

    @Override
    protected Object handleDownMessage(Event evt, Message msg, Address dest, int length) {
        boolean rc;
        long block_time;
        if (dest == null || dest.isMulticastAddress()) {
            this.log.error(this.getClass().getSimpleName() + " doesn't handle multicast messages; passing message down");
            return this.down_prot.down(evt);
        }
        FlowControl.Credit cred = this.sent.get(dest);
        if (cred == null) {
            return this.down_prot.down(evt);
        }
        long l = block_time = this.max_block_times != null ? this.getMaxBlockTime(length) : this.max_block_time;
        while (this.running && this.sent.containsKey(dest) && !(rc = cred.decrementIfEnoughCredits(length, block_time)) && this.running && this.max_block_times == null) {
            if (!cred.needToSendCreditRequest()) continue;
            this.sendCreditRequest(dest, Math.max(0L, this.max_credits - cred.get()));
        }
        return this.down_prot.down(evt);
    }

    @Override
    protected void handleViewChange(Vector<Address> mbrs) {
        super.handleViewChange(mbrs);
        if (mbrs == null) {
            return;
        }
        for (Address addr : mbrs) {
            if (this.sent.containsKey(addr)) continue;
            this.sent.put(addr, new FlowControl.Credit(this.max_credits));
        }
        Iterator<Address> it = this.sent.keySet().iterator();
        while (it.hasNext()) {
            Address addr;
            addr = it.next();
            if (mbrs.contains(addr)) continue;
            it.remove();
        }
    }

    @Override
    protected void handleCredit(Address sender, long increase) {
        FlowControl.Credit cred;
        if (sender == null || (cred = this.sent.get(sender)) == null || increase <= 0L) {
            return;
        }
        long new_credit = Math.min(this.max_credits, cred.get() + increase);
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("received " + increase + " credits from ").append(sender).append(", old credits: ").append(cred).append(", new credits: ").append(new_credit);
            this.log.trace(sb);
        }
        cred.increment(increase);
    }
}

