/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.locking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class Owner
implements Streamable {
    protected Address address;
    protected long thread_id;

    public Owner() {
    }

    public Owner(Address address, long thread_id) {
        this.address = address;
        this.thread_id = thread_id;
    }

    public Address getAddress() {
        return this.address;
    }

    public long getThreadId() {
        return this.thread_id;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        Util.writeAddress(this.address, out);
        out.writeLong(this.thread_id);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.address = Util.readAddress(in);
        this.thread_id = in.readLong();
    }

    public boolean equals(Object obj) {
        Owner other = (Owner)obj;
        return this.address.equals(other.address) && this.thread_id == other.thread_id;
    }

    public int hashCode() {
        return (int)((long)this.address.hashCode() + this.thread_id);
    }

    public String toString() {
        return this.address + "::" + this.thread_id;
    }
}

