/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodsMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.modules.Module;

public class EjbConcurrencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        if (eeModuleDescription == null) {
            return;
        }
        for (ComponentDescription description : eeModuleDescription.getComponentDescriptions()) {
            if (!(description instanceof SingletonComponentDescription) && !(description instanceof StatefulComponentDescription)) continue;
            try {
                EnterpriseBeanMetaData bean;
                Class componentClass = module.getClassLoader().loadClass(description.getComponentClassName());
                this.checkMethodOverrides(componentClass, (SessionBeanComponentDescription)description, index);
                if (ejbJarMetaData == null || !((bean = ejbJarMetaData.getEnterpriseBean(((SessionBeanComponentDescription)description).getEJBName())) instanceof SessionBean31MetaData)) continue;
                this.processBean((SessionBean31MetaData)bean, (SessionBeanComponentDescription)description, index, componentClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Could not load EJB class " + description.getComponentClassName(), (Throwable)e);
            }
        }
    }

    private void checkMethodOverrides(Class<?> componentClass, SessionBeanComponentDescription description, DeploymentReflectionIndex index) {
        ClassReflectionIndex classIndex = index.getClassIndex(componentClass);
        Iterator<Map.Entry<MethodIdentifier, LockType>> iterator = description.getMethodApplicableLockTypes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MethodIdentifier, LockType> entry = iterator.next();
            if (!this.annotationOverridden(classIndex, index, entry.getKey(), Lock.class)) continue;
            iterator.remove();
        }
        for (Map.Entry<MethodIdentifier, AccessTimeout> entry : description.getMethodApplicableAccessTimeouts().entrySet()) {
            if (!this.annotationOverridden(classIndex, index, entry.getKey(), AccessTimeout.class)) continue;
            iterator.remove();
        }
    }

    private boolean annotationOverridden(ClassReflectionIndex<?> classIndex, DeploymentReflectionIndex index, MethodIdentifier method, Class<? extends Annotation> annotation) {
        ClassReflectionIndex cindex = classIndex;
        while (cindex != null && cindex.getIndexedClass() != Object.class) {
            Method m = cindex.getMethod(method);
            if (m != null) {
                return !m.isAnnotationPresent(annotation);
            }
            cindex = index.getClassIndex(cindex.getIndexedClass().getSuperclass());
        }
        return false;
    }

    private void processBean(SessionBean31MetaData singletonBeanMetaData, SessionBeanComponentDescription singletonComponentDescription, DeploymentReflectionIndex reflectionIndex, Class<?> componentClass) throws DeploymentUnitProcessingException {
        ConcurrentMethodsMetaData concurrentMethods = singletonBeanMetaData.getConcurrentMethods();
        if (concurrentMethods != null) {
            for (ConcurrentMethodMetaData concurrentMethod : concurrentMethods) {
                AccessTimeoutMetaData accessTimeout;
                LockType methodLockType = concurrentMethod.getLockType();
                Method method = this.resolveMethod(reflectionIndex, componentClass, concurrentMethod.getMethod());
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)method);
                if (methodLockType != null) {
                    singletonComponentDescription.setLockType(methodLockType, methodIdentifier);
                }
                if ((accessTimeout = concurrentMethod.getAccessTimeout()) == null) continue;
                singletonComponentDescription.setAccessTimeout(new AccessTimeout(){

                    public long value() {
                        return accessTimeout.getTimeout();
                    }

                    public TimeUnit unit() {
                        return accessTimeout.getUnit();
                    }

                    public Class<? extends Annotation> annotationType() {
                        return AccessTimeout.class;
                    }
                }, methodIdentifier);
            }
        }
    }

    private Method resolveMethod(DeploymentReflectionIndex index, Class<Object> componentClass, NamedMethodMetaData methodData) throws DeploymentUnitProcessingException {
        if (componentClass == null) {
            throw new DeploymentUnitProcessingException("Could not find method" + methodData.getMethodName() + "with parameter types" + methodData.getMethodParams() + " referenced in ejb-jar.xml");
        }
        ClassReflectionIndex classIndex = index.getClassIndex(componentClass);
        if (methodData.getMethodParams() == null) {
            Collection methods = classIndex.getAllMethods(methodData.getMethodName());
            if (methods.isEmpty()) {
                return this.resolveMethod(index, componentClass.getSuperclass(), methodData);
            }
            if (methods.size() > 1) {
                throw new DeploymentUnitProcessingException("More than one method " + methodData.getMethodName() + "found on class" + componentClass.getName() + " referenced in ejb-jar.xml. Specify the parameter types to resolve the ambiguity");
            }
            return (Method)methods.iterator().next();
        }
        Collection methods = classIndex.getAllMethods(methodData.getMethodName(), methodData.getMethodParams().size());
        for (Method method : methods) {
            boolean match = true;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (method.getParameterTypes()[i].getName().equals(methodData.getMethodParams().get(i))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return this.resolveMethod(index, componentClass.getSuperclass(), methodData);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

