/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DeclareRoles;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class DeclareRolesProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final Logger logger = Logger.getLogger(DeclareRolesProcessor.class);
    private static final DotName DECLARE_ROLES_DOT_NAME = DotName.createSimple((String)DeclareRoles.class.getName());

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        List declareRolesAnnotations = (List)annotationsOnBean.get(DECLARE_ROLES_DOT_NAME);
        if (declareRolesAnnotations == null || declareRolesAnnotations.isEmpty()) {
            return;
        }
        if (declareRolesAnnotations.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one @DeclareRoles annotation found on bean: " + componentDescription.getEJBName());
        }
        AnnotationInstance declareRolesAnnotation = (AnnotationInstance)declareRolesAnnotations.get(0);
        if (!(declareRolesAnnotation.target() instanceof ClassInfo)) {
            throw new DeploymentUnitProcessingException("@DeclareRoles can appear only on a class. Target: " + declareRolesAnnotation.target() + " is not a class");
        }
        AnnotationValue annotationValue = declareRolesAnnotation.value();
        Object[] roles = annotationValue.asStringArray();
        if (roles != null) {
            componentDescription.addDeclaredRoles((String[])roles);
            logger.debug((Object)(componentDescription.getEJBName() + " bean declares roles: " + Arrays.toString(roles)));
        }
    }
}

