/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.MethodDescription;
import org.jboss.as.ejb3.component.stateful.StatefulBMTInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceDestroyInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentSessionIdGeneratingInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class StatefulComponentDescription
extends SessionBeanComponentDescription {
    private static final Logger logger = Logger.getLogger(StatefulComponentDescription.class);
    private MethodDescription afterBegin;
    private MethodDescription afterCompletion;
    private MethodDescription beforeCompletion;
    private Set<StatefulRemoveMethod> removeMethods = new HashSet<StatefulRemoveMethod>();
    private StatefulTimeoutInfo statefulTimeout;

    public StatefulComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName);
        this.addStatefulSessionSynchronizationInterceptor();
    }

    private void addStatefulSessionSynchronizationInterceptor() {
        this.getConfigurators().addFirst(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                ComponentInstanceInterceptorFactory interceptorFactory = new ComponentInstanceInterceptorFactory(){

                    protected Interceptor create(Component component, InterceptorFactoryContext context) {
                        return new StatefulSessionSynchronizationInterceptor();
                    }
                };
                configuration.addComponentInterceptor((InterceptorFactory)interceptorFactory, 1280, false);
            }
        });
    }

    public ComponentConfiguration createConfiguration(EEApplicationDescription applicationDescription) {
        ComponentConfiguration statefulComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, applicationDescription.getClassConfiguration(this.getComponentClassName()));
        statefulComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new StatefulComponentCreateServiceFactory());
        if (this.getTransactionManagementType() == TransactionManagementType.BEAN) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    ComponentInstanceInterceptorFactory bmtComponentInterceptorFactory = new ComponentInstanceInterceptorFactory(){

                        protected Interceptor create(Component component, InterceptorFactoryContext context) {
                            if (!(component instanceof StatefulSessionComponent)) {
                                throw new IllegalArgumentException("Component " + component + " with component class: " + component.getComponentClass() + " isn't a stateful component");
                            }
                            return new StatefulBMTInterceptor((StatefulSessionComponent)component);
                        }
                    };
                    configuration.addComponentInterceptor((InterceptorFactory)bmtComponentInterceptorFactory, 1024, false);
                }
            });
        }
        return statefulComponentConfiguration;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return true;
    }

    public MethodDescription getAfterBegin() {
        return this.afterBegin;
    }

    public MethodDescription getAfterCompletion() {
        return this.afterCompletion;
    }

    public MethodDescription getBeforeCompletion() {
        return this.beforeCompletion;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
    }

    public void setAfterBegin(String className, String methodName) {
        this.afterBegin = new MethodDescription(className, methodName, new String[0]);
    }

    public void setAfterCompletion(String className, String methodName) {
        this.afterCompletion = new MethodDescription(className, methodName, Boolean.TYPE.getName());
    }

    public void setBeforeCompletion(String className, String methodName) {
        this.beforeCompletion = new MethodDescription(className, methodName, new String[0]);
    }

    @Override
    protected void setupViewInterceptors(ViewDescription view) {
        super.setupViewInterceptors(view);
        this.addRemoveMethodInterceptor(view);
        this.addStatefulInstanceAssociatingInterceptor(view);
    }

    public void addRemoveMethod(MethodIdentifier removeMethod, boolean retainIfException) {
        if (removeMethod == null) {
            throw new IllegalArgumentException("@Remove method identifier cannot be null");
        }
        this.removeMethods.add(new StatefulRemoveMethod(removeMethod, retainIfException));
    }

    public Set<StatefulRemoveMethod> getRemoveMethods() {
        return Collections.unmodifiableSet(this.removeMethods);
    }

    public StatefulTimeoutInfo getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(StatefulTimeoutInfo statefulTimeout) {
        this.statefulTimeout = statefulTimeout;
    }

    private void addStatefulInstanceAssociatingInterceptor(ViewDescription view) {
        final Object sessionIdContextKey = new Object();
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                StatefulComponentSessionIdGeneratingInterceptorFactory sessionIdGeneratingInterceptorFactory = new StatefulComponentSessionIdGeneratingInterceptorFactory(sessionIdContextKey);
                viewConfiguration.addViewPostConstructInterceptor((InterceptorFactory)sessionIdGeneratingInterceptorFactory, 256);
                viewConfiguration.addViewPreDestroyInterceptor((InterceptorFactory)new StatefulComponentInstanceDestroyInterceptorFactory(sessionIdContextKey), 256);
                for (Method method : viewConfiguration.getProxyFactory().getCachedMethods()) {
                    if ((!method.getName().equals("hashCode") || method.getParameterTypes().length != 0) && (!method.getName().equals("equals") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                    viewConfiguration.addViewInterceptor(method, (InterceptorFactory)new StatefulIdentityInterceptorFactory(sessionIdContextKey), 256);
                }
            }
        });
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor((InterceptorFactory)new StatefulComponentInstanceInterceptorFactory(sessionIdContextKey), 1280);
            }
        });
    }

    private void addRemoveMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                StatefulComponentDescription statefulComponentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
                Set<StatefulRemoveMethod> removeMethods = statefulComponentDescription.getRemoveMethods();
                if (removeMethods.isEmpty()) {
                    return;
                }
                block0: for (Method viewMethod : configuration.getProxyFactory().getCachedMethods()) {
                    MethodIdentifier viewMethodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)viewMethod);
                    for (StatefulRemoveMethod removeMethod : removeMethods) {
                        if (!removeMethod.methodIdentifier.equals(viewMethodIdentifier)) continue;
                        configuration.addViewInterceptor(viewMethod, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(removeMethod.retainIfException)), 1792);
                        continue block0;
                    }
                }
            }
        });
    }

    public class StatefulRemoveMethod {
        private final MethodIdentifier methodIdentifier;
        private final boolean retainIfException;

        StatefulRemoveMethod(MethodIdentifier method, boolean retainIfException) {
            if (method == null) {
                throw new IllegalArgumentException("@Remove method cannot be null");
            }
            this.methodIdentifier = method;
            this.retainIfException = retainIfException;
        }

        public MethodIdentifier getMethodIdentifier() {
            return this.methodIdentifier;
        }

        public boolean isRetainIfException() {
            return this.retainIfException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatefulRemoveMethod that = (StatefulRemoveMethod)o;
            return this.methodIdentifier.equals(that.methodIdentifier);
        }

        public int hashCode() {
            return this.methodIdentifier.hashCode();
        }
    }
}

