/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class BindingMetricHandlers {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;
    private static final ModelNode NO_METRICS = new ModelNode().set("no metrics available");

    private BindingMetricHandlers() {
    }

    public static class BoundPortHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-port";
        public static final OperationStepHandler INSTANCE = new BoundPortHandler();

        private BoundPortHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                int port = managedBinding.getBindAddress().getPort();
                result.set(port);
            }
        }
    }

    public static class BoundAddressHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-address";
        public static final OperationStepHandler INSTANCE = new BoundAddressHandler();

        private BoundAddressHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                InetAddress addr = managedBinding.getBindAddress().getAddress();
                result.set(addr.getHostAddress());
            }
        }
    }

    public static class BoundHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound";
        public static final OperationStepHandler INSTANCE = new BoundHandler();

        private BoundHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            result.set(binding.isBound());
        }
    }

    static abstract class AbstractBindingMetricsHandler
    implements OperationStepHandler {
        AbstractBindingMetricsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            final PathElement element = address.getLastElement();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode result = context.getResult();
                    ServiceController controller = context.getServiceRegistry(false).getRequiredService(SOCKET_BINDING.append(new String[]{element.getValue()}));
                    if (controller != null) {
                        SocketBinding binding = (SocketBinding)SocketBinding.class.cast(controller.getValue());
                        AbstractBindingMetricsHandler.this.execute(operation, binding, result);
                    } else {
                        result.set(NO_METRICS);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }

        abstract void execute(ModelNode var1, SocketBinding var2, ModelNode var3);
    }
}

