/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class AnnotationIndexProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(AnnotationIndexProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ArrayList<ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        List resourceRoots = phaseContext.getDeploymentUnit().getAttachment(Attachments.RESOURCE_ROOTS);
        if (resourceRoots != null) {
            allResourceRoots.addAll(resourceRoots);
        }
        allResourceRoots.add(phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT));
        for (ResourceRoot resourceRoot : allResourceRoots) {
            Boolean shouldIndexResource;
            if (resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX) != null) continue;
            VirtualFile indexFile = resourceRoot.getRoot().getChild("META-INF/jandex.idx");
            if (indexFile.exists()) {
                try {
                    IndexReader reader = new IndexReader(indexFile.openStream());
                    resourceRoot.putAttachment(Attachments.ANNOTATION_INDEX, reader.read());
                    logger.tracef("Found and read index at: %s", (Object)indexFile);
                    continue;
                }
                catch (Exception e) {
                    logger.debugf("Could not read provided index: %s", (Object)indexFile, (Object)e);
                }
            }
            if ((shouldIndexResource = resourceRoot.getAttachment(Attachments.INDEX_RESOURCE_ROOT)) != null && !shouldIndexResource.booleanValue()) continue;
            List indexIgnorePathList = resourceRoot.getAttachment(Attachments.INDEX_IGNORE_PATHS);
            final HashSet indexIgnorePaths = indexIgnorePathList != null && !indexIgnorePathList.isEmpty() ? new HashSet(indexIgnorePathList) : null;
            final VirtualFile virtualFile = resourceRoot.getRoot();
            Indexer indexer = new Indexer();
            try {
                VisitorAttributes visitorAttributes = new VisitorAttributes();
                visitorAttributes.setLeavesOnly(true);
                visitorAttributes.setRecurseFilter(new VirtualFileFilter(){

                    public boolean accepts(VirtualFile file) {
                        return indexIgnorePaths == null || !indexIgnorePaths.contains(file.getPathNameRelativeTo(virtualFile));
                    }
                });
                List classChildren = virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", visitorAttributes));
                for (VirtualFile classFile : classChildren) {
                    InputStream inputStream = null;
                    try {
                        inputStream = classFile.openStream();
                        indexer.index(inputStream);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Could not index class " + classFile.getPathNameRelativeTo(virtualFile) + " in archive '" + virtualFile + "'"), (Throwable)e);
                    }
                    finally {
                        VFSUtils.safeClose((Closeable)inputStream);
                    }
                }
                Index index = indexer.complete();
                resourceRoot.putAttachment(Attachments.ANNOTATION_INDEX, index);
                logger.tracef("Generated index for archive %s", (Object)virtualFile);
            }
            catch (Throwable t) {
                throw new DeploymentUnitProcessingException("Failed to index deployment root for annotations", t);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

