/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl.environment;

import com.sun.enterprise.registration.impl.environment.SystemEnvironment;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;

class SolarisSystemEnvironment
extends SystemEnvironment {
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;
    private static final int MODEL = 4;
    private String kstatCpuInfo = null;

    SolarisSystemEnvironment() {
        this.setHostId(this.getCommandOutput("/usr/bin/hostid"));
        this.setSystemModel(this.getSolarisModel());
        this.setSystemManufacturer(this.getSolarisSystemManufacturer());
        this.setCpuManufacturer(this.getSolarisCpuManufacturer());
        this.setSerialNumber(this.getSolarisSN());
        this.setPhysMem(this.getSolarisPhysMem());
        this.setSockets(this.getSolarisSockets());
        this.setCores(this.getSolarisCores());
        this.setVirtCpus(this.getSolarisVirtCpus());
        this.setCpuName(this.getSolarisCpuName());
        this.setClockRate(this.getSolarisClockRate());
    }

    private String getSolarisClockRate() {
        String data = this.getSolarisKstatCpuInfo();
        String[] lines = data.split("\n");
        String token = "clock_MHz";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(token)) continue;
            return line.substring(line.indexOf(token) + token.length()).trim();
        }
        return "";
    }

    private String getSolarisCpuName() {
        String data = this.getSolarisKstatCpuInfo();
        String[] lines = data.split("\n");
        String token = "brand";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(token)) continue;
            return line.substring(line.indexOf(token) + token.length()).trim();
        }
        return "";
    }

    private String getSolarisVirtCpus() {
        String data = this.getSolarisKstatCpuInfo();
        int cnt = 0;
        String[] lines = data.split("\n");
        String token = " cpu_info ";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.indexOf(token) == -1) continue;
            ++cnt;
        }
        return "" + cnt;
    }

    private String getSolarisCores() {
        String data = this.getSolarisKstatCpuInfo();
        HashSet<String> set = new HashSet<String>();
        String[] lines = data.split("\n");
        String coreIdToken = "core_id";
        String coreId = "";
        String chipIdToken = "chip_id";
        String chipId = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith(chipIdToken)) {
                chipId = line.substring(line.indexOf(chipIdToken) + chipIdToken.length()).trim();
            }
            if (!line.startsWith(coreIdToken)) continue;
            coreId = line.substring(line.indexOf(coreIdToken) + coreIdToken.length()).trim();
            set.add(chipId + "," + coreId);
        }
        return "" + set.size();
    }

    private String getSolarisPhysMem() {
        String data = this.getCommandOutput("/usr/sbin/prtconf");
        boolean cnt = false;
        String[] lines = data.split("\n");
        String token = "Memory size:";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(token) || (line = line.substring(line.indexOf(token) + token.length()).trim()).indexOf(" ") == -1) continue;
            return line.substring(0, line.indexOf(" ")).trim();
        }
        return "0";
    }

    private String getSolarisSockets() {
        String data = this.getSolarisKstatCpuInfo();
        HashSet<String> set = new HashSet<String>();
        String[] lines = data.split("\n");
        String token = "chip_id";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith(token)) continue;
            String id = line.substring(line.indexOf(token) + token.length()).trim();
            set.add(id);
        }
        return "" + set.size();
    }

    private synchronized String getSolarisKstatCpuInfo() {
        if (this.kstatCpuInfo == null) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    SolarisSystemEnvironment.this.kstatCpuInfo = SolarisSystemEnvironment.this.getCommandOutput("/usr/bin/kstat", "cpu_info");
                }
            };
            thread.start();
            try {
                thread.join(2000L);
                if (thread.isAlive()) {
                    thread.interrupt();
                    this.kstatCpuInfo = "";
                }
            }
            catch (InterruptedException ie) {
                thread.interrupt();
            }
        }
        return this.kstatCpuInfo;
    }

    private String getSolarisModel() {
        String[] lines;
        String tmp = this.getFileContent("/var/run/psn");
        if (tmp.length() > 0 && 4 <= (lines = tmp.split("\n")).length) {
            return lines[3] + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return this.getCommandOutput("/usr/bin/uname", "-i") + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
        }
        String model = this.getSmbiosData("1", "Product: ");
        if (model == null || model.trim().equals("")) {
            model = this.getCommandOutput("/usr/bin/uname", "-i");
        }
        if (model == null) {
            model = "";
        }
        return model.trim() + "::" + this.getCommandOutput("/usr/bin/uname", "-v");
    }

    private String getSolarisCpuManufacturer() {
        String[] lines;
        String tmp = this.getFileContent("/var/run/psn");
        if (tmp.length() > 0 && 3 <= (lines = tmp.split("\n")).length) {
            return lines[2];
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("4", "Manufacturer: ");
    }

    private String getSolarisSystemManufacturer() {
        String[] lines;
        String tmp = this.getFileContent("/var/run/psn");
        if (tmp.length() > 0 && 2 <= (lines = tmp.split("\n")).length) {
            return lines[1];
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            if (this.getCommandOutput("/usr/bin/uname", "-m").equals("sun4us")) {
                return "Fujitsu";
            }
            return "Sun Microsystems, Inc";
        }
        return this.getSmbiosData("1", "Manufacturer: ");
    }

    private String getSolarisSN() {
        String[] lines;
        String tmp = this.getFileContent("/var/run/psn");
        if (tmp.length() > 0 && 1 <= (lines = tmp.split("\n")).length) {
            return lines[0];
        }
        String tmpSN = this.getSneepSN();
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        tmpSN = this.getSmbiosData("1", "Serial Number: ");
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        tmpSN = this.getSmbiosData("3", "Serial Number: ");
        if (tmpSN.length() > 0) {
            return tmpSN;
        }
        if ("sparc".equalsIgnoreCase(System.getProperty("os.arch"))) {
            tmpSN = this.getSNViaPrtfruX();
            if (tmpSN.length() > 0) {
                return tmpSN;
            }
            tmpSN = this.getSNViaPrtfru();
            if (tmpSN.length() > 0) {
                return tmpSN;
            }
        }
        return "";
    }

    private String getSmbiosData(String type, String target) {
        String output = this.getCommandOutput("/usr/sbin/smbios", "-t", type);
        for (String s : output.split("\n")) {
            String tmp;
            String lowerCaseStr;
            int indx;
            if (!s.contains(target) || (indx = s.indexOf(target) + target.length()) >= s.length() || (lowerCaseStr = (tmp = s.substring(indx).trim()).toLowerCase(Locale.US)).startsWith("not available") || lowerCaseStr.startsWith("to be filled by o.e.m")) continue;
            return tmp;
        }
        return "";
    }

    private String getSneepSN() {
        String basedir = this.getCommandOutput("pkgparam", "SUNWsneep", "BASEDIR");
        File f = new File(basedir + "/bin/sneep");
        if (f.exists()) {
            String sneepSN = this.getCommandOutput(basedir + "/bin/sneep");
            if (sneepSN.equalsIgnoreCase("unknown")) {
                return "";
            }
            return sneepSN;
        }
        return "";
    }

    private String getSNViaPrtfruX() {
        String data = this.getCommandOutput("/usr/sbin/prtfru", "-x");
        boolean FRUTREE_FLAG = false;
        boolean FRUNAME_FLAG = false;
        boolean MB_LABEL_FLAG = false;
        boolean SYSTEM_BOARD_FLAG = false;
        String[] lines = data.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String tok;
            int index;
            String line = lines[i];
            if (SYSTEM_BOARD_FLAG && (index = line.indexOf(tok = "<Sun_Serial_No value=\"")) != -1) {
                String val = line.substring(index + tok.length());
                String[] vals = val.split("\"");
                if (vals.length <= 0) break;
                return vals[0].trim();
            }
            if (line.indexOf("</ContainerData>") != -1) {
                FRUTREE_FLAG = false;
                FRUNAME_FLAG = false;
                SYSTEM_BOARD_FLAG = false;
            }
            if (FRUNAME_FLAG && line.indexOf("<Container name=\"system-board\">") != -1) {
                SYSTEM_BOARD_FLAG = true;
            }
            if (FRUTREE_FLAG && line.indexOf("<Fru name=\"chassis\">") != -1) {
                FRUNAME_FLAG = true;
            }
            if (line.indexOf("<Location name=\"frutree\">") == -1) continue;
            FRUTREE_FLAG = true;
        }
        return "";
    }

    private String getSNViaPrtfru() {
        String data = this.getCommandOutput("/usr/sbin/prtfru");
        boolean CHASSIS_FLAG = false;
        String[] lines = data.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String tok;
            int index;
            String line = lines[i];
            if (CHASSIS_FLAG && (index = line.indexOf(tok = "/ManR/Sun_Serial_No:")) != -1) {
                String val = line.substring(index + tok.length());
                return val.trim();
            }
            if (line.indexOf("/frutree/chassis/system-board (container)") != -1) {
                CHASSIS_FLAG = true;
                continue;
            }
            if (line.indexOf("/frutree/chassis/MB?Label=MB/system-board (container)") == -1) continue;
            CHASSIS_FLAG = true;
        }
        return "";
    }
}

