/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9;

import com.sun.enterprise.ee.cms.impl.base.GMSThreadFactory;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSMonitor;
import com.sun.enterprise.mgmt.transport.AbstractNetworkManager;
import com.sun.enterprise.mgmt.transport.BlockingIOMulticastSender;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.VirtualMulticastSender;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyNetworkManager;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyPeerID;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyUtil;
import com.sun.enterprise.mgmt.transport.grizzly.PingMessageListener;
import com.sun.enterprise.mgmt.transport.grizzly.PongMessageListener;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.GrizzlyCacheableSelectionKeyHandler;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.GrizzlyMessageDispatcherFilter;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.GrizzlyMessageProtocolParser;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.GrizzlyTCPConnectorWrapper;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.GrizzlyUDPConnectorWrapper;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.MulticastSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.PortRange;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.ReusableTCPSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandlerPool;
import com.sun.grizzly.connectioncache.spi.transport.ConnectionFinder;
import com.sun.grizzly.connectioncache.spi.transport.ContactInfo;
import com.sun.grizzly.util.GrizzlyExecutorService;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.ThreadPoolConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyNetworkManager1_9
extends GrizzlyNetworkManager {
    public static final String MESSAGE_SELECTION_KEY_TAG = "selectionKey";
    private int maxPoolSize;
    private int corePoolSize;
    private long keepAliveTime;
    private int poolQueueSize;
    private String virtualUriList;
    private GrizzlyExecutorService execService;
    private ExecutorService multicastSenderThreadPool = null;
    public final Controller controller = new Controller();
    public final Map<SelectionKey, String> selectionKeyMap = new ConcurrentHashMap<SelectionKey, String>();
    public TCPSelectorHandler tcpSelectorHandler = null;
    private final CountDownLatch controllerGate = new CountDownLatch(1);
    private boolean controllerGateIsReady = false;
    private Throwable controllerGateStartupException = null;

    public void localConfigure(Map properties) {
        this.maxPoolSize = Utility.getIntProperty(GrizzlyConfigConstants.MAX_POOLSIZE.toString(), 50, properties);
        this.corePoolSize = Utility.getIntProperty(GrizzlyConfigConstants.CORE_POOLSIZE.toString(), 20, properties);
        this.keepAliveTime = Utility.getLongProperty(GrizzlyConfigConstants.KEEP_ALIVE_TIME.toString(), 60000L, properties);
        this.poolQueueSize = Utility.getIntProperty(GrizzlyConfigConstants.POOL_QUEUE_SIZE.toString(), 4096, properties);
        this.virtualUriList = Utility.getStringProperty(GrizzlyConfigConstants.DISCOVERY_URI_LIST.toString(), null, properties);
    }

    @Override
    public synchronized void initialize(String groupName, String instanceName, Map properties) throws IOException {
        GMSMonitor monitor;
        super.initialize(groupName, instanceName, properties);
        this.instanceName = instanceName;
        this.groupName = groupName;
        this.configure(properties);
        this.localConfigure(properties);
        System.out.println("Grizzly 1.9 NetworkManager");
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        if (ctx != null && (monitor = ctx.getGMSMonitor()) != null) {
            monitor.setSendWriteTimeout(this.sendWriteTimeoutMillis);
        }
        InetAddress localInetAddress = null;
        if (this.host != null) {
            localInetAddress = InetAddress.getByName(this.host);
        }
        ThreadPoolConfig threadPoolConfig = new ThreadPoolConfig("GMS-GrizzlyControllerThreadPool-Group-" + groupName, this.corePoolSize, this.maxPoolSize, new ArrayBlockingQueue(this.poolQueueSize), this.poolQueueSize, this.keepAliveTime, TimeUnit.MILLISECONDS, null, 5, null);
        this.execService = GrizzlyExecutorService.createInstance((ThreadPoolConfig)threadPoolConfig);
        this.controller.setThreadPool((ExecutorService)this.execService);
        CacheableConnectorHandlerPool cacheableHandlerPool = new CacheableConnectorHandlerPool(this.controller, this.highWaterMark, this.numberToReclaim, this.maxParallelSendConnections, (ConnectionFinder)new ConnectionFinder<ConnectorHandler>(){

            public ConnectorHandler find(ContactInfo<ConnectorHandler> cinfo, Collection<ConnectorHandler> idleConnections, Collection<ConnectorHandler> busyConnections) throws IOException {
                if (!idleConnections.isEmpty()) {
                    return null;
                }
                return (ConnectorHandler)cinfo.createConnection();
            }
        });
        this.controller.setConnectorHandlerPool((ConnectorHandlerPool)cacheableHandlerPool);
        this.tcpSelectorHandler = new ReusableTCPSelectorHandler();
        this.tcpSelectorHandler.setPortRange(new PortRange(this.tcpStartPort, this.tcpEndPort));
        this.tcpSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)new GrizzlyCacheableSelectionKeyHandler(this.highWaterMark, this.numberToReclaim, this));
        this.tcpSelectorHandler.setInet(localInetAddress);
        this.controller.addSelectorHandler((SelectorHandler)this.tcpSelectorHandler);
        if (GrizzlyUtil.isSupportNIOMulticast()) {
            MulticastSelectorHandler multicastSelectorHandler = new MulticastSelectorHandler();
            multicastSelectorHandler.setPort(this.multicastPort);
            multicastSelectorHandler.setSelectionKeyHandler((SelectionKeyHandler)new GrizzlyCacheableSelectionKeyHandler(this.highWaterMark, this.numberToReclaim, this));
            multicastSelectorHandler.setMulticastAddress(this.multicastAddress);
            multicastSelectorHandler.setNetworkInterface(this.networkInterfaceName);
            multicastSelectorHandler.setInet(localInetAddress);
            this.controller.addSelectorHandler((SelectorHandler)multicastSelectorHandler);
        }
        DefaultProtocolChainInstanceHandler pciHandler = new DefaultProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                ProtocolChain protocolChain = (ProtocolChain)this.protocolChains.poll();
                if (protocolChain == null) {
                    protocolChain = new DefaultProtocolChain();
                    protocolChain.addFilter((ProtocolFilter)GrizzlyMessageProtocolParser.createParserProtocolFilter(null));
                    protocolChain.addFilter((ProtocolFilter)new GrizzlyMessageDispatcherFilter(GrizzlyNetworkManager1_9.this));
                }
                return protocolChain;
            }
        };
        this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)pciHandler);
        SelectorFactory.setMaxSelectors((int)this.writeSelectorPoolSize);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        super.start();
        ControllerStateListener controllerStateListener = new ControllerStateListener(){

            public void onStarted() {
            }

            public void onReady() {
                if (GrizzlyNetworkManager1_9.this.LOG.isLoggable(Level.FINER)) {
                    GrizzlyNetworkManager1_9.this.LOG.log(Level.FINER, "GrizzlyNetworkManager1_9 is ready");
                }
                GrizzlyNetworkManager1_9.this.controllerGateIsReady = true;
                GrizzlyNetworkManager1_9.this.controllerGate.countDown();
            }

            public void onStopped() {
                GrizzlyNetworkManager1_9.this.controllerGate.countDown();
            }

            public void onException(Throwable e) {
                if (GrizzlyNetworkManager1_9.this.controllerGate.getCount() > 0L) {
                    AbstractNetworkManager.getLogger().log(Level.SEVERE, "Exception during starting the controller", e);
                    GrizzlyNetworkManager1_9.this.controllerGate.countDown();
                    GrizzlyNetworkManager1_9.this.controllerGateStartupException = e;
                } else {
                    AbstractNetworkManager.getLogger().log(Level.SEVERE, "Exception during controller processing", e);
                }
            }
        };
        this.controller.addStateListener(controllerStateListener);
        new Thread((Runnable)this.controller).start();
        long controllerStartTime = System.currentTimeMillis();
        try {
            this.controllerGate.await(this.startTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long durationInMillis = System.currentTimeMillis() - controllerStartTime;
        if (!this.controller.isStarted() || !this.controllerGateIsReady) {
            if (this.controllerGateStartupException != null) {
                throw new IllegalStateException("Grizzly Controller was not started and ready after " + durationInMillis + " ms", this.controllerGateStartupException);
            }
            throw new IllegalStateException("Grizzly Controller was not started and ready after " + durationInMillis + " ms");
        }
        if (this.controllerGateIsReady) {
            GrizzlyNetworkManager1_9.getLogger().config("Grizzly controller listening on " + this.tcpSelectorHandler.getInet() + ":" + this.tcpSelectorHandler.getPort() + ". Controller started in " + durationInMillis + " ms");
        }
        this.tcpPort = this.tcpSelectorHandler.getPort();
        if (this.localPeerID == null) {
            InetAddress firstInetAddress;
            String uniqueHost = this.host;
            if (uniqueHost == null && (firstInetAddress = NetworkUtility.getFirstInetAddress()) != null) {
                uniqueHost = firstInetAddress.getHostAddress();
            }
            if (uniqueHost == null) {
                throw new IOException("can not find an unique host");
            }
            this.localPeerID = new PeerID<GrizzlyPeerID>(new GrizzlyPeerID(uniqueHost, this.tcpPort, this.multicastAddress, this.multicastPort), this.groupName, this.instanceName);
            this.peerIDMap.put(this.instanceName, this.localPeerID);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.log(Level.FINE, "local peer id = " + this.localPeerID);
            }
        }
        this.tcpSender = new GrizzlyTCPConnectorWrapper(this.controller, this.sendWriteTimeoutMillis, this.host, this.tcpPort, this.localPeerID);
        GrizzlyUDPConnectorWrapper udpConnectorWrapper = new GrizzlyUDPConnectorWrapper(this.controller, this.sendWriteTimeoutMillis, this.host, this.multicastPort, this.multicastAddress, this.localPeerID);
        this.udpSender = udpConnectorWrapper;
        List<PeerID> virtualPeerIdList = this.getVirtualPeerIDList(this.virtualUriList);
        if (virtualPeerIdList != null && !virtualPeerIdList.isEmpty()) {
            this.vms = new VirtualMulticastSender(this, virtualPeerIdList);
            this.multicastSender = this.vms;
        } else if (GrizzlyUtil.isSupportNIOMulticast()) {
            this.multicastSender = udpConnectorWrapper;
        } else {
            boolean FAIRNESS = true;
            GMSThreadFactory tf = new GMSThreadFactory("GMS-McastMsgProcessor-Group-" + this.groupName + "-thread");
            this.multicastSenderThreadPool = new ThreadPoolExecutor(10, 10, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024, true), tf);
            this.multicastSender = new BlockingIOMulticastSender(this.host, this.multicastAddress, this.multicastPort, this.networkInterfaceName, this.multicastPacketSize, this.localPeerID, this.multicastSenderThreadPool, this.multicastTimeToLive, this);
        }
        if (this.tcpSender != null) {
            this.tcpSender.start();
        }
        if (this.udpSender != null) {
            this.udpSender.start();
        }
        if (this.multicastSender != null) {
            this.multicastSender.start();
        }
        this.addMessageListener(new PingMessageListener());
        this.addMessageListener(new PongMessageListener());
        this.running = true;
    }

    public void addRemotePeer(PeerID peerID, SelectionKey selectionKey) {
        if (peerID == null) {
            return;
        }
        if (peerID.equals(this.localPeerID)) {
            return;
        }
        String instanceName = peerID.getInstanceName();
        if (instanceName != null && peerID.getUniqueID() instanceof GrizzlyPeerID) {
            PeerID previous = this.peerIDMap.put(instanceName, peerID);
            if (previous == null && this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("addRemotePeer: " + instanceName + " peerId:" + peerID);
            }
            if (selectionKey != null) {
                this.selectionKeyMap.put(selectionKey, instanceName);
            }
        }
        this.addToVMS(peerID);
    }

    @Override
    public void removeRemotePeer(String instanceName) {
        for (Map.Entry<SelectionKey, String> entry : this.selectionKeyMap.entrySet()) {
            if (!entry.getValue().equals(instanceName)) continue;
            if (GrizzlyNetworkManager1_9.getLogger().isLoggable(Level.FINE)) {
                GrizzlyNetworkManager1_9.getLogger().log(Level.FINE, "remove selection key for instance name: " + entry.getValue() + " selectionKey:" + entry.getKey());
            }
            this.tcpSelectorHandler.getSelectionKeyHandler().cancel(entry.getKey());
            this.selectionKeyMap.remove(entry.getKey());
        }
    }

    public void removeRemotePeer(SelectionKey selectionKey) {
        if (selectionKey == null) {
            return;
        }
        this.selectionKeyMap.remove(selectionKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PeerID> getVirtualPeerIDList(String virtualUriList) {
        if (virtualUriList == null) {
            return null;
        }
        this.LOG.config("DISCOVERY_URI_LIST = " + virtualUriList);
        ArrayList<PeerID> virtualPeerIdList = new ArrayList<PeerID>();
        if (virtualUriList.indexOf(",") > 0) {
            String[] addresses = virtualUriList.split(",");
            if (addresses.length <= 0) return virtualPeerIdList;
            List<String> virtualUriStringList = Arrays.asList(addresses);
            for (String uriString : virtualUriStringList) {
                try {
                    PeerID<GrizzlyPeerID> peerID = this.getPeerIDFromURI(uriString);
                    if (peerID == null) continue;
                    virtualPeerIdList.add(peerID);
                    this.LOG.config("VIRTUAL_MULTICAST_URI = " + uriString + ", Converted PeerID = " + peerID);
                }
                catch (URISyntaxException use) {
                    if (!this.LOG.isLoggable(Level.CONFIG)) continue;
                    this.LOG.log(Level.CONFIG, "failed to parse the virtual multicast uri(" + uriString + ")", use);
                }
            }
            return virtualPeerIdList;
        } else {
            try {
                PeerID<GrizzlyPeerID> peerID = this.getPeerIDFromURI(virtualUriList);
                if (peerID == null) return virtualPeerIdList;
                virtualPeerIdList.add(peerID);
                this.LOG.config("VIRTUAL_MULTICAST_URI = " + virtualUriList + ", Converted PeerID = " + peerID);
                return virtualPeerIdList;
            }
            catch (URISyntaxException use) {
                if (!this.LOG.isLoggable(Level.CONFIG)) return virtualPeerIdList;
                this.LOG.log(Level.CONFIG, "failed to parse the virtual multicast uri(" + virtualUriList + ")", use);
            }
        }
        return virtualPeerIdList;
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
        if (this.tcpSender != null) {
            this.tcpSender.stop();
        }
        if (this.udpSender != null) {
            this.udpSender.stop();
        }
        if (this.multicastSender != null) {
            this.multicastSender.stop();
        }
        if (this.multicastSenderThreadPool != null) {
            this.multicastSenderThreadPool.shutdown();
        }
        this.peerIDMap.clear();
        this.selectionKeyMap.clear();
        this.pingMessageLockMap.clear();
        this.controller.stop();
        this.execService.shutdown();
    }

    @Override
    public void beforeDispatchingMessage(MessageEvent messageEvent, Map piggyback) {
        Object value;
        if (messageEvent == null) {
            return;
        }
        SelectionKey selectionKey = null;
        if (piggyback != null && (value = piggyback.get(MESSAGE_SELECTION_KEY_TAG)) instanceof SelectionKey) {
            selectionKey = (SelectionKey)value;
        }
        if (!this.isLeavingMessage(messageEvent)) {
            this.addRemotePeer(messageEvent.getSourcePeerID(), selectionKey);
        }
    }

    @Override
    public void afterDispatchingMessage(MessageEvent messageEvent, Map piggyback) {
    }

    @Override
    protected Logger getGrizzlyLogger() {
        return LoggerUtils.getLogger();
    }
}

