/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.config;

import com.sun.enterprise.admin.commands.CreateSsl;
import com.sun.enterprise.admin.commands.DeleteSsl;
import com.sun.enterprise.admin.commands.SslConfigHandler;
import com.sun.enterprise.web.WebContainer;
import java.text.MessageFormat;
import org.glassfish.api.ActionReport;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="http-listener")
public class WebSslConfigHandler
implements SslConfigHandler {
    @LogMessageInfo(message="Network Listener named {0} does not exist.  Creating or using the named protocol element instead.", level="INFO")
    private static final String CREATE_SSL_HTTP_NOT_FOUND = "AS-WEB-GLUE-00272";
    @LogMessageInfo(message="Network Listener named {0} to which this ssl element is being added already has an ssl element.", level="INFO")
    private static final String CREATE_SSL_HTTP_ALREADY_EXISTS = "AS-WEB-GLUE-00273";
    @LogMessageInfo(message="HTTP Listener named {0} not found", level="INFO")
    private static final String DELETE_SSL_HTTP_LISTENER_NOT_FOUND = "AS-WEB-GLUE-00274";
    @LogMessageInfo(message="Ssl element does not exist for Listener named {0}", level="INFO")
    private static final String DELETE_SSL_ELEMENT_DOES_NOT_EXIST = "AS-WEB-GLUE-00275";

    public void create(final CreateSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener listener = netConfig.getNetworkListener(command.listenerId);
        try {
            Protocol httpProtocol;
            if (listener == null) {
                report.setMessage(WebContainer.rb.getString(MessageFormat.format(CREATE_SSL_HTTP_NOT_FOUND, command.listenerId)));
                httpProtocol = command.findOrCreateProtocol(command.listenerId);
            } else {
                httpProtocol = listener.findHttpProtocol();
                Ssl ssl = httpProtocol.getSsl();
                if (ssl != null) {
                    report.setMessage(WebContainer.rb.getString(MessageFormat.format(CREATE_SSL_HTTP_ALREADY_EXISTS, command.listenerId)));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                    command.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)httpProtocol);
        }
        catch (TransactionFailure e) {
            command.reportError(report, e);
        }
        command.reportSuccess(report);
    }

    public void delete(DeleteSsl command, ActionReport report) {
        NetworkConfig netConfig = command.config.getNetworkConfig();
        NetworkListener networkListener = netConfig.getNetworkListener(command.listenerId);
        if (networkListener == null) {
            report.setMessage(WebContainer.rb.getString(MessageFormat.format(DELETE_SSL_HTTP_LISTENER_NOT_FOUND, command.listenerId)));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Protocol protocol = networkListener.findHttpProtocol();
        if (protocol.getSsl() == null) {
            report.setMessage(WebContainer.rb.getString(MessageFormat.format(DELETE_SSL_ELEMENT_DOES_NOT_EXIST, command.listenerId)));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) {
                    param.setSsl(null);
                    return null;
                }
            }, (ConfigBeanProxy)networkListener.findHttpProtocol());
        }
        catch (TransactionFailure e) {
            command.reportError(report, (Exception)((Object)e));
        }
    }
}

