/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class VersionUtils {
    private VersionUtils() {
    }

    public static boolean isJava15OrAbove() {
        return VersionUtils.isJavaVersionOrAbove("1.5");
    }

    public static boolean isJava16OrAbove() {
        return VersionUtils.isJavaVersionOrAbove("1.6");
    }

    public static boolean isJavaVersionAbove(String string) {
        try {
            Version version = new Version(VersionUtils.getJavaVersion());
            Version version2 = new Version(string);
            return version.compareTo(version2) >= 1;
        }
        catch (VersionFormatException versionFormatException) {
            return false;
        }
    }

    public static boolean isJavaVersionOrAbove(String string) {
        try {
            Version version = new Version(VersionUtils.getJavaVersion());
            Version version2 = new Version(string);
            return version.compareTo(version2) >= 0;
        }
        catch (VersionFormatException versionFormatException) {
            return false;
        }
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

