/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import org.limewire.util.ByteOrder;
import org.limewire.util.ByteUtils;

public final class NetworkUtils {
    public static final int CLASS_C_NETMASK = -256;

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] byArray, int n) {
        return NetworkUtils.isValidAddress(byArray) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidAddressAndPort(String string, int n) {
        return NetworkUtils.isValidAddress(string) && NetworkUtils.isValidPort(n);
    }

    public static boolean isValidPort(int n) {
        return n > 0 && n <= 65535;
    }

    public static boolean isValidAddress(byte[] byArray) {
        return !NetworkUtils.isAnyLocalAddress(byArray) && !NetworkUtils.isInvalidAddress(byArray) && !NetworkUtils.isBroadcastAddress(byArray) && !NetworkUtils.isDocumentationAddress(byArray);
    }

    public static boolean isValidAddress(InetAddress inetAddress) {
        return !inetAddress.isAnyLocalAddress() && !NetworkUtils.isInvalidAddress(inetAddress) && !NetworkUtils.isBroadcastAddress(inetAddress) && !NetworkUtils.isDocumentationAddress(inetAddress);
    }

    public static boolean isValidAddress(String string) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isDottedIPV4(String string) {
        int n;
        int n2 = 0;
        while (n2 < 3) {
            n = string.indexOf(".");
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(0, n);
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 < 0 || n3 > 255) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n2;
            string = string.substring(Math.min(n + 1, string.length()), string.length());
        }
        if (string.indexOf(".") != -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string);
            if (n < 0 || n > 255) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isAddress(String string) {
        int n = (string = string.trim()).indexOf(":");
        if (n == -1) {
            return string.length() > 0;
        }
        if (n > 0) {
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                return NetworkUtils.isValidPort(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isValidSocketAddress(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !inetSocketAddress.isUnresolved() && NetworkUtils.isValidAddress(inetSocketAddress.getAddress()) && NetworkUtils.isValidPort(inetSocketAddress.getPort());
    }

    public static boolean isLocalAddress(InetAddress inetAddress) {
        InetAddress inetAddress2;
        Enumeration<InetAddress> enumeration;
        NetworkInterface networkInterface;
        Enumeration<NetworkInterface> enumeration2;
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            enumeration2 = NetworkInterface.getNetworkInterfaces();
            while (enumeration2.hasMoreElements()) {
                networkInterface = enumeration2.nextElement();
                enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    inetAddress2 = enumeration.nextElement();
                    if (!Arrays.equals(inetAddress.getAddress(), inetAddress2.getAddress())) continue;
                    return true;
                }
            }
        }
        catch (SocketException socketException) {
            return false;
        }
        try {
            enumeration2 = NetworkInterface.getNetworkInterfaces();
            while (enumeration2.hasMoreElements()) {
                networkInterface = enumeration2.nextElement();
                enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    inetAddress2 = enumeration.nextElement();
                    if (!Arrays.equals(inetAddress.getAddress(), inetAddress2.getAddress())) continue;
                    return true;
                }
            }
        }
        catch (SocketException socketException) {
            return false;
        }
        return false;
    }

    public static boolean isLocalAddress(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !inetSocketAddress.isUnresolved() && NetworkUtils.isLocalAddress(inetSocketAddress.getAddress());
    }

    public static boolean isCloseIP(InetAddress inetAddress, InetAddress inetAddress2) {
        return NetworkUtils.isCloseIP(inetAddress.getAddress(), inetAddress2.getAddress());
    }

    public static boolean isCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isIPv4Address(byArray) && NetworkUtils.isIPv4Address(byArray2) || NetworkUtils.isIPv4MappedAddress(byArray) && NetworkUtils.isIPv4MappedAddress(byArray2)) {
            return byArray[byArray.length - 4] == byArray2[byArray2.length - 4];
        }
        return false;
    }

    static boolean isVeryCloseIP(byte[] byArray, byte[] byArray2) {
        if (NetworkUtils.isIPv4Address(byArray) && NetworkUtils.isIPv4Address(byArray2) || NetworkUtils.isIPv4MappedAddress(byArray) && NetworkUtils.isIPv4MappedAddress(byArray2)) {
            return byArray[byArray.length - 4] == byArray2[byArray2.length - 4] && byArray[byArray.length - 3] == byArray2[byArray2.length - 3];
        }
        return false;
    }

    static boolean isPrivateAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress() || NetworkUtils.isUniqueLocalUnicastAddress(inetAddress) || NetworkUtils.isBroadcastAddress(inetAddress) || NetworkUtils.isInvalidAddress(inetAddress) || NetworkUtils.isDocumentationAddress(inetAddress);
    }

    static boolean isPrivateAddress(byte[] byArray) {
        return NetworkUtils.isAnyLocalAddress(byArray) || NetworkUtils.isInvalidAddress(byArray) || NetworkUtils.isLoopbackAddress(byArray) || NetworkUtils.isLinkLocalAddress(byArray) || NetworkUtils.isSiteLocalAddress(byArray) || NetworkUtils.isUniqueLocalUnicastAddress(byArray) || NetworkUtils.isBroadcastAddress(byArray) || NetworkUtils.isDocumentationAddress(byArray);
    }

    public static final String ip2string(byte[] byArray) {
        return NetworkUtils.ip2string(byArray, 0);
    }

    public static final String ip2string(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append(ByteOrder.ubyte2int(byArray[n]));
        stringBuilder.append('.');
        stringBuilder.append(ByteOrder.ubyte2int(byArray[n + 1]));
        stringBuilder.append('.');
        stringBuilder.append(ByteOrder.ubyte2int(byArray[n + 2]));
        stringBuilder.append('.');
        stringBuilder.append(ByteOrder.ubyte2int(byArray[n + 3]));
        return stringBuilder.toString();
    }

    public static boolean isLocalHost(Socket socket) {
        return NetworkUtils.isLocalAddress(socket.getInetAddress());
    }

    public static int getClassC(InetAddress inetAddress) {
        return NetworkUtils.getMaskedIP(inetAddress, -256);
    }

    public static int getMaskedIP(InetAddress inetAddress, int n) {
        byte[] byArray = inetAddress.getAddress();
        return ByteOrder.beb2int(byArray, byArray.length - 4) & n;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress instanceof Inet4Address && !inetAddress.isLoopbackAddress()) {
            return inetAddress;
        }
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        inetAddress = enumeration2.nextElement();
                        if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                        return inetAddress;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }

    public static byte[] getBytes(SocketAddress socketAddress) throws UnknownHostException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.toString());
        }
        return NetworkUtils.getBytes(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
    }

    public static byte[] getBytes(InetAddress inetAddress, int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Port out of range: " + n);
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 2] = (byte)(n >> 8 & 0xFF);
        byArray2[byArray2.length - 1] = (byte)(n & 0xFF);
        return byArray2;
    }

    public static byte[] getBytes(SocketAddress socketAddress, java.nio.ByteOrder byteOrder) throws UnknownHostException {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.toString());
        }
        return NetworkUtils.getBytes(inetSocketAddress.getAddress(), inetSocketAddress.getPort(), byteOrder);
    }

    public static byte[] getBytes(InetAddress inetAddress, int n, java.nio.ByteOrder byteOrder) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Port out of range: " + n);
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IllegalArgumentException("invalid addr: " + inetAddress);
        }
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (byteOrder == java.nio.ByteOrder.BIG_ENDIAN) {
            ByteUtils.short2beb((short)n, byArray2, byArray2.length - 2);
        } else {
            ByteUtils.short2leb((short)n, byArray2, byArray2.length - 2);
        }
        return byArray2;
    }

    public static boolean isSameAddressSpace(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return NetworkUtils.isSameAddressSpace(((InetSocketAddress)socketAddress).getAddress(), ((InetSocketAddress)socketAddress2).getAddress());
    }

    public static boolean isSameAddressSpace(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress == null || inetAddress2 == null) {
            return false;
        }
        return inetAddress instanceof Inet4Address && inetAddress2 instanceof Inet4Address || inetAddress instanceof Inet6Address && inetAddress2 instanceof Inet6Address;
    }

    public static byte[] getIPv6AddressBytes(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        switch (byArray.length) {
            case 16: {
                return byArray;
            }
            case 4: {
                byte[] byArray2 = new byte[16];
                byArray2[10] = -1;
                byArray2[11] = -1;
                System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
                return byArray2;
            }
        }
        throw new IllegalArgumentException("unhandled address length");
    }

    public static boolean isIPv6Compatible(InetAddress inetAddress) {
        int n = inetAddress.getAddress().length;
        return n == 4 || n == 16;
    }

    private static boolean isIPv4Address(byte[] byArray) {
        return byArray.length == 4;
    }

    static boolean isIPv4CompatibleAddress(byte[] byArray) {
        return byArray.length == 16 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == 0 && byArray[11] == 0;
    }

    static boolean isIPv4MappedAddress(byte[] byArray) {
        return byArray.length == 16 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }

    private static boolean isInvalidAddress(InetAddress inetAddress) {
        return NetworkUtils.isInvalidAddress(inetAddress.getAddress());
    }

    private static boolean isInvalidAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return byArray[byArray.length - 4] == 0;
        }
        return false;
    }

    static boolean isAnyLocalAddress(byte[] byArray) {
        if (byArray.length == 4 || byArray.length == 16) {
            byte by = 0;
            for (int i = 0; i < byArray.length; ++i) {
                by = (byte)(by | byArray[i]);
            }
            return by == 0;
        }
        return false;
    }

    static boolean isLoopbackAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 127;
        }
        if (byArray.length == 16) {
            byte by = 0;
            for (int i = 0; i < 15; ++i) {
                by = (byte)(by | byArray[i]);
            }
            return by == 0 && byArray[15] == 1;
        }
        return false;
    }

    static boolean isLinkLocalAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 169 && (byArray[byArray.length - 3] & 0xFF) == 254;
        }
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 128;
        }
        return false;
    }

    static boolean isSiteLocalAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 10 || (byArray[byArray.length - 4] & 0xFF) == 172 && (byArray[byArray.length - 3] & 0xF0) == 16 || (byArray[byArray.length - 4] & 0xFF) == 192 && (byArray[byArray.length - 3] & 0xFF) == 168;
        }
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xC0) == 192;
        }
        return false;
    }

    public static boolean isUniqueLocalUnicastAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isUniqueLocalUnicastAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isUniqueLocalUnicastAddress(byte[] byArray) {
        if (byArray.length == 16) {
            return (byArray[0] & 0xFE) == 252;
        }
        return false;
    }

    public static boolean isBroadcastAddress(InetAddress inetAddress) {
        return NetworkUtils.isBroadcastAddress(inetAddress.getAddress());
    }

    private static boolean isBroadcastAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4Address(byArray) || NetworkUtils.isIPv4MappedAddress(byArray)) {
            return (byArray[byArray.length - 4] & 0xFF) == 255;
        }
        return false;
    }

    public static boolean isPrivateIPv4CompatibleAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isPrivateIPv4CompatibleAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isPrivateIPv4CompatibleAddress(byte[] byArray) {
        if (NetworkUtils.isIPv4CompatibleAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, byArray2.length);
            return NetworkUtils.isPrivateAddress(byArray2);
        }
        return false;
    }

    public static boolean isDocumentationAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return NetworkUtils.isDocumentationAddress(inetAddress.getAddress());
        }
        return false;
    }

    private static boolean isDocumentationAddress(byte[] byArray) {
        if (byArray.length == 16) {
            return (byArray[0] & 0xFF) == 32 && (byArray[1] & 0xFF) == 1 && (byArray[2] & 0xFF) == 13 && (byArray[3] & 0xFF) == 184;
        }
        return false;
    }

    static int parsePort(String string) throws IOException {
        try {
            int n = Integer.parseInt(string);
            if (!NetworkUtils.isValidPort(n)) {
                throw new IOException("invalid port: " + n);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw (IOException)new IOException().initCause(numberFormatException);
        }
    }

    static InetAddress getAndCheckAddress(String string) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IOException("invalid addr: " + inetAddress);
        }
        return inetAddress;
    }

    static int getAndCheckIpPortSeparator(String string) throws IOException {
        int n = string.indexOf(":");
        if (n <= 0 || n != string.lastIndexOf(":") || n == string.length() - 1) {
            throw new IOException("invalid separator in http: " + string);
        }
        return n;
    }

    public static String convertIPPortToHex(String string, int n) {
        String[] stringArray = string.split("\\.");
        byte[] byArray = new byte[6];
        int n2 = 0;
        for (String string2 : stringArray) {
            byArray[n2++] = (byte)Integer.parseInt(string2);
        }
        byte[] byArray2 = ByteUtils.smallIntToByteArray(n);
        byArray[4] = byArray2[0];
        byArray[5] = byArray2[1];
        return ByteUtils.encodeHex(byArray);
    }

    public static String convertHexToIPPort(String string) {
        if (string.length() != 12) {
            return null;
        }
        byte[] byArray = ByteUtils.decodeHex(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byArray[0] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[1] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[2] & 0xFF);
        stringBuilder.append(".");
        stringBuilder.append(byArray[3] & 0xFF);
        stringBuilder.append(":");
        int n = ByteUtils.byteArrayToSmallInt(byArray, 4);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("c0a801131ae1 => " + NetworkUtils.convertHexToIPPort("c0a801131ae1"));
        String string = NetworkUtils.convertHexToIPPort("c0a801131ae1");
        String string2 = string.split(":")[0];
        int n = Integer.parseInt(string.split(":")[1]);
        System.out.println(string2 + ":" + n + " => " + NetworkUtils.convertIPPortToHex(string2, n));
    }
}

