/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConverterObjectInputStream
extends ObjectInputStream {
    private static final Log LOG = LogFactory.getLog(ConverterObjectInputStream.class);
    private Map<String, String> lookups = new HashMap<String, String>(8);

    public ConverterObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.createLookups();
    }

    public void revertToDefault() {
        this.lookups.clear();
        this.createLookups();
    }

    private void createLookups() {
        this.lookups.put("com.limegroup.gnutella.util.FileComparator", "org.limewire.collection.FileComparator");
        this.lookups.put("com.limegroup.gnutella.util.Comparators$CaseInsensitiveStringComparator", "org.limewire.collection.Comparators$CaseInsensitiveStringComparator");
        this.lookups.put("com.limegroup.gnutella.util.StringComparator", "org.limewire.collection.StringComparator");
        this.lookups.put("com.sun.java.util.collections", "java.util");
    }

    public void addLookup(String string, String string2) {
        this.lookups.put(string, string2);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int n;
        String string;
        String string2;
        String string3;
        boolean bl;
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        String string4 = objectStreamClass.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking up class: " + string4));
        }
        boolean bl2 = bl = string4.startsWith("[L") && string4.endsWith(";");
        if (bl) {
            string4 = string4.substring(2, string4.length() - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stripping array form off, resulting in: " + string4));
            }
        }
        ObjectStreamClass objectStreamClass2 = (string3 = this.lookups.get(string4)) != null ? ObjectStreamClass.lookup(Class.forName(string3)) : ((string2 = this.lookups.get(string = (n = string4.lastIndexOf(46)) != -1 ? string4.substring(0, n) : "")) != null ? (string2.length() == 0 ? ObjectStreamClass.lookup(Class.forName(string4.substring(n + 1))) : ObjectStreamClass.lookup(Class.forName(string2 + '.' + string4.substring(n + 1)))) : objectStreamClass);
        if (LOG.isDebugEnabled() && objectStreamClass2 != objectStreamClass) {
            LOG.debug((Object)("Located substitute class: " + objectStreamClass2.getName()));
        }
        if (bl && objectStreamClass != objectStreamClass2) {
            objectStreamClass2 = ObjectStreamClass.lookup(Class.forName("[L" + objectStreamClass2.getName() + ";"));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Re-added array wrapper, for class: " + objectStreamClass2.getName()));
            }
        }
        return objectStreamClass2;
    }
}

