/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.ManagedThread;
import org.limewire.concurrent.ThreadPoolExecutor;

public class ExecutorsHelper {
    public static ExecutorService newProcessingQueue(String string) {
        return ExecutorsHelper.newProcessingQueue(ExecutorsHelper.daemonThreadFactory(string));
    }

    public static ExecutorService newProcessingQueue(ThreadFactory threadFactory) {
        return Executors.unconfigurableExecutorService(ExecutorsHelper.newSingleThreadExecutor(threadFactory));
    }

    public static java.util.concurrent.ThreadPoolExecutor newSingleThreadExecutor(ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static ExecutorService newThreadPool(String string) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(string)));
    }

    public static ExecutorService newThreadPool(ThreadFactory threadFactory) {
        return Executors.unconfigurableExecutorService(new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory));
    }

    public static ExecutorService newFixedSizeThreadPool(int n, String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(string));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(threadPoolExecutor);
    }

    public static ExecutorService newFixedSizePriorityThreadPool(int n, String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, 5L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), ExecutorsHelper.daemonThreadFactory(string));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(threadPoolExecutor);
    }

    public static ThreadFactory defaultThreadFactory(String string) {
        return new DefaultThreadFactory(string, false);
    }

    public static ThreadFactory daemonThreadFactory(String string) {
        return new DefaultThreadFactory(string, true);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        private final boolean daemon;

        public DefaultThreadFactory(String string, boolean bl) {
            this.name = string;
            this.daemon = bl;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            ManagedThread managedThread = new ManagedThread(runnable, this.name);
            if (this.daemon) {
                managedThread.setDaemon(true);
            }
            return managedThread;
        }
    }
}

