/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import org.limewire.collection.Range;
import org.limewire.util.ByteOrder;

class Interval
extends Range
implements Serializable {
    static final long serialVersionUID = -2562093104400487554L;
    private final int low;
    private final int high;

    protected Interval(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("low: " + l + ", high: " + l2);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("low < min int:" + l);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("high > max int:" + l2);
        }
        this.low = (int)l;
        this.high = (int)l2;
    }

    protected Interval(long l) {
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("singleton < min:" + l);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("singleton > max int:" + l);
        }
        this.low = (int)l;
        this.high = (int)l;
    }

    @Override
    public byte[] toBytes() {
        byte[] byArray = new byte[8];
        this.toBytes(byArray, 0);
        return byArray;
    }

    @Override
    public void toBytes(byte[] byArray, int n) {
        ByteOrder.int2beb(this.low, byArray, n);
        ByteOrder.int2beb(this.high, byArray, n + 4);
    }

    @Override
    public final long getLow() {
        return this.low;
    }

    @Override
    public final long getHigh() {
        return this.high;
    }

    @Override
    public final boolean isLong() {
        return false;
    }
}

