/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<List<T>> split(int n, List<T> list) {
        LinkedList<List<T>> linkedList = new LinkedList<List<T>>();
        for (int i = 0; i < list.size(); i += n) {
            int n2 = Math.min(list.size(), i + n);
            LinkedList<T> linkedList2 = new LinkedList<T>();
            for (int j = i; j < n2; ++j) {
                linkedList2.add(list.get(j));
            }
            linkedList.add(linkedList2);
        }
        return linkedList;
    }

    public static <T> List<T> listOf(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> List<T> listOf(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return new LinkedHashSet<T>(collection);
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> Iterator<T> readOnlyIterator(final Iterator<T> iterator) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("read only iterator");
            }
        };
    }

    public static <T> Collection<T> flatten(Collection<? extends Collection<? extends T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<T> collection2 : collection) {
            arrayList.addAll(collection2);
        }
        return arrayList;
    }
}

