/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct8
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private byte[] values;
    private static final int BITS_PER_VALUE = 8;

    public Direct8(int n) {
        super(n, 8);
        this.values = new byte[n];
    }

    public Direct8(DataInput dataInput, int n) throws IOException {
        super(n, 8);
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = dataInput.readByte();
        }
        n2 = n % 8;
        if (n2 != 0) {
            int n3 = 8 - n2;
            for (int i = 0; i < n3; ++i) {
                dataInput.readByte();
            }
        }
        this.values = byArray;
    }

    public Direct8(byte[] byArray) {
        super(byArray.length, 8);
        this.values = byArray;
    }

    @Override
    public long get(int n) {
        return 0xFFL & (long)this.values[n];
    }

    @Override
    public void set(int n, long l) {
        this.values[n] = (byte)(l & 0xFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, (byte)0);
    }

    @Override
    public Object getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

