/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct64
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private long[] values;
    private static final int BITS_PER_VALUE = 64;

    public Direct64(int n) {
        super(n, 64);
        this.values = new long[n];
    }

    public Direct64(DataInput dataInput, int n) throws IOException {
        super(n, 64);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = dataInput.readLong();
        }
        this.values = lArray;
    }

    public Direct64(long[] lArray) {
        super(lArray.length, 64);
        this.values = lArray;
    }

    @Override
    public long get(int n) {
        return this.values[n];
    }

    @Override
    public void set(int n, long l) {
        this.values[n] = l;
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.length * 8;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, 0L);
    }

    public long[] getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

