/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;

public final class Util {
    private Util() {
    }

    public static <T> T get(FST<T> fST, IntsRef intsRef) throws IOException {
        Object t;
        assert (fST.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fST.getFirstArc(new FST.Arc());
        Object t2 = t = fST.outputs.getNoOutput();
        for (int i = 0; i < intsRef.length; ++i) {
            if (fST.findTargetArc(intsRef.ints[intsRef.offset + i], arc, arc) == null) {
                return null;
            }
            if (arc.output == t) continue;
            t2 = fST.outputs.add(t2, arc.output);
        }
        if (fST.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != t) {
            return fST.outputs.add(t2, arc.output);
        }
        return t2;
    }

    public static <T> T get(FST<T> fST, char[] cArray, int n, int n2) throws IOException {
        int n3;
        Object t;
        assert (fST.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fST.getFirstArc(new FST.Arc());
        int n4 = n + n2;
        Object t2 = t = fST.outputs.getNoOutput();
        for (int i = n; i < n4; i += Character.charCount(n3)) {
            n3 = Character.codePointAt(cArray, i);
            if (fST.findTargetArc(n3, arc, arc) != null) continue;
            return null;
        }
        if (fST.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != t) {
            return fST.outputs.add(t2, arc.output);
        }
        return t2;
    }

    public static <T> T get(FST<T> fST, CharSequence charSequence) throws IOException {
        int n;
        Object t;
        assert (fST.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fST.getFirstArc(new FST.Arc());
        int n2 = charSequence.length();
        Object t2 = t = fST.outputs.getNoOutput();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(charSequence, i);
            if (fST.findTargetArc(n, arc, arc) != null) continue;
            return null;
        }
        if (fST.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != t) {
            return fST.outputs.add(t2, arc.output);
        }
        return t2;
    }

    public static <T> T get(FST<T> fST, BytesRef bytesRef) throws IOException {
        Object t;
        assert (fST.inputType == FST.INPUT_TYPE.BYTE1);
        FST.Arc<T> arc = fST.getFirstArc(new FST.Arc());
        Object t2 = t = fST.outputs.getNoOutput();
        for (int i = 0; i < bytesRef.length; ++i) {
            if (fST.findTargetArc(bytesRef.bytes[i + bytesRef.offset] & 0xFF, arc, arc) == null) {
                return null;
            }
            if (arc.output == t) continue;
            t2 = fST.outputs.add(t2, arc.output);
        }
        if (fST.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != t) {
            return fST.outputs.add(t2, arc.output);
        }
        return t2;
    }

    public static <T> void toDot(FST<T> fST, Writer writer, boolean bl, boolean bl2) throws IOException {
        FST.Arc<T> arc = fST.getFirstArc(new FST.Arc());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(arc);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        BitSet bitSet = new BitSet();
        bitSet.set(arc.target);
        writer.write("digraph FST {\n");
        writer.write("  rankdir = LR; splines=true; concentrate=true; ordering=out; ranksep=2.5; \n");
        if (!bl2) {
            writer.write("  node [shape=circle, width=.2, height=.2, style=filled]\n");
        }
        Util.emitDotState(writer, "initial", "point", "white", "");
        Util.emitDotState(writer, Integer.toString(arc.target), "circle", fST.isExpandedTarget(arc) ? "blue" : null, "");
        writer.write("  initial -> " + arc.target + "\n");
        Object t = fST.outputs.getNoOutput();
        int n = 0;
        while (!arrayList2.isEmpty()) {
            int n2;
            Object object;
            arrayList.addAll(arrayList2);
            arrayList2.clear();
            writer.write("\n  // Transitions and states at level: " + ++n + "\n");
            block1: while (!arrayList.isEmpty()) {
                object = (FST.Arc)arrayList.remove(arrayList.size() - 1);
                if (!fST.targetHasArcs((FST.Arc<T>)object)) continue;
                n2 = ((FST.Arc)object).target;
                fST.readFirstTargetArc((FST.Arc<T>)object, (FST.Arc<T>)object);
                while (true) {
                    if (((FST.Arc)object).target >= 0 && !bitSet.get(((FST.Arc)object).target)) {
                        boolean bl3 = fST.isExpandedTarget((FST.Arc<T>)object);
                        Util.emitDotState(writer, Integer.toString(((FST.Arc)object).target), "circle", bl3 ? "blue" : null, bl2 ? Integer.toString(((FST.Arc)object).target) : "");
                        bitSet.set(((FST.Arc)object).target);
                        arrayList2.add(new FST.Arc().copyFrom(object));
                        arrayList3.add(((FST.Arc)object).target);
                    }
                    String string = ((FST.Arc)object).output != t ? "/" + fST.outputs.outputToString(((FST.Arc)object).output) : "";
                    String string2 = ((FST.Arc)object).label == -1 ? "~" : Util.printableLabel(((FST.Arc)object).label);
                    writer.write("  " + n2 + " -> " + ((FST.Arc)object).target + " [label=\"" + string2 + string + "\"]\n");
                    if (((FST.Arc)object).isLast()) continue block1;
                    fST.readNextArc((FST.Arc<T>)object);
                }
            }
            if (bl && arrayList3.size() > 1) {
                writer.write("  {rank=same; ");
                object = arrayList3.iterator();
                while (object.hasNext()) {
                    n2 = (Integer)object.next();
                    writer.write(n2 + "; ");
                }
                writer.write(" }\n");
            }
            arrayList3.clear();
        }
        writer.write("  -1 [style=filled, color=black, shape=circle, label=\"\"]\n\n");
        writer.write("  {rank=sink; -1 }\n");
        writer.write("}\n");
        writer.flush();
    }

    private static void emitDotState(Writer writer, String string, String string2, String string3, String string4) throws IOException {
        writer.write("  " + string + " [" + (string2 != null ? "shape=" + string2 : "") + " " + (string3 != null ? "color=" + string3 : "") + " " + (string4 != null ? "label=\"" + string4 + "\"" : "label=\"\"") + " " + "]\n");
    }

    private static String printableLabel(int n) {
        if (n >= 32 && n <= 125) {
            return Character.toString((char)n);
        }
        return "0x" + Integer.toHexString(n);
    }
}

