/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.util.AverageGuessMemoryModel;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.MemoryModel;

public final class RamUsageEstimator {
    public static final int NUM_BYTES_SHORT = 2;
    public static final int NUM_BYTES_INT = 4;
    public static final int NUM_BYTES_LONG = 8;
    public static final int NUM_BYTES_FLOAT = 4;
    public static final int NUM_BYTES_DOUBLE = 8;
    public static final int NUM_BYTES_CHAR = 2;
    public static final int NUM_BYTES_OBJECT_HEADER = 8;
    public static final int NUM_BYTES_OBJECT_REF = Constants.JRE_IS_64BIT ? 8 : 4;
    public static final int NUM_BYTES_ARRAY_HEADER = 12 + NUM_BYTES_OBJECT_REF;
    private MemoryModel memoryModel;
    private final Map<Object, Object> seen;
    private int refSize;
    private int arraySize;
    private int classSize;
    private boolean checkInterned;
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    public RamUsageEstimator() {
        this(new AverageGuessMemoryModel());
    }

    public RamUsageEstimator(boolean bl) {
        this(new AverageGuessMemoryModel(), bl);
    }

    public RamUsageEstimator(MemoryModel memoryModel) {
        this(memoryModel, true);
    }

    public RamUsageEstimator(MemoryModel memoryModel, boolean bl) {
        this.memoryModel = memoryModel;
        this.checkInterned = bl;
        this.seen = new IdentityHashMap<Object, Object>(64);
        this.refSize = memoryModel.getReferenceSize();
        this.arraySize = memoryModel.getArraySize();
        this.classSize = memoryModel.getClassSize();
    }

    public long estimateRamUsage(Object object) {
        long l = this.size(object);
        this.seen.clear();
        return l;
    }

    private long size(Object object) {
        Class<?> clazz;
        if (object == null) {
            return 0L;
        }
        if (this.checkInterned && object instanceof String && object == ((String)object).intern()) {
            return 0L;
        }
        if (this.seen.containsKey(object)) {
            return 0L;
        }
        this.seen.put(object, null);
        if (clazz.isArray()) {
            return this.sizeOfArray(object);
        }
        long l = 0L;
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                if (fieldArray[i].getType().isPrimitive()) {
                    l += (long)this.memoryModel.getPrimitiveSize(fieldArray[i].getType());
                    continue;
                }
                l += (long)this.refSize;
                fieldArray[i].setAccessible(true);
                try {
                    Object object2 = fieldArray[i].get(object);
                    if (object2 == null) continue;
                    l += this.size(object2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return l += (long)this.classSize;
    }

    private long sizeOfArray(Object object) {
        int n = Array.getLength(object);
        if (n == 0) {
            return 0L;
        }
        long l = this.arraySize;
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            l += (long)(n * this.memoryModel.getPrimitiveSize(clazz));
        } else {
            for (int i = 0; i < n; ++i) {
                l += (long)this.refSize + this.size(Array.get(object, i));
            }
        }
        return l;
    }

    public static String humanReadableUnits(long l, DecimalFormat decimalFormat) {
        String string = l / 0x40000000L > 0L ? String.valueOf(decimalFormat.format((float)l / 1.0737418E9f)) + " GB" : (l / 0x100000L > 0L ? String.valueOf(decimalFormat.format((float)l / 1048576.0f)) + " MB" : (l / 1024L > 0L ? String.valueOf(decimalFormat.format((float)l / 1024.0f)) + " KB" : String.valueOf(l) + " bytes"));
        return string;
    }
}

