/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public final class IndexableBinaryStringTools {
    private static final CodingCase[] CODING_CASES = new CodingCase[]{new CodingCase(7, 1), new CodingCase(14, 6, 2), new CodingCase(13, 5, 3), new CodingCase(12, 4, 4), new CodingCase(11, 3, 5), new CodingCase(10, 2, 6), new CodingCase(9, 1, 7), new CodingCase(8, 0)};

    private IndexableBinaryStringTools() {
    }

    @Deprecated
    public static int getEncodedLength(ByteBuffer byteBuffer) throws IllegalArgumentException {
        if (byteBuffer.hasArray()) {
            return IndexableBinaryStringTools.getEncodedLength(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.arrayOffset());
        }
        throw new IllegalArgumentException("original argument must have a backing array");
    }

    public static int getEncodedLength(byte[] byArray, int n, int n2) {
        return (int)((8L * (long)n2 + 14L) / 15L) + 1;
    }

    @Deprecated
    public static int getDecodedLength(CharBuffer charBuffer) throws IllegalArgumentException {
        if (charBuffer.hasArray()) {
            return IndexableBinaryStringTools.getDecodedLength(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.limit() - charBuffer.arrayOffset());
        }
        throw new IllegalArgumentException("encoded argument must have a backing array");
    }

    public static int getDecodedLength(char[] cArray, int n, int n2) {
        int n3 = n2 - 1;
        if (n3 <= 0) {
            return 0;
        }
        long l = cArray[n + n2 - 1];
        long l2 = n3 - 1;
        return (int)((l2 * 15L + 7L) / 8L + l);
    }

    @Deprecated
    public static void encode(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (!byteBuffer.hasArray() || !charBuffer.hasArray()) {
            throw new IllegalArgumentException("Arguments must have backing arrays");
        }
        int n = byteBuffer.arrayOffset();
        int n2 = byteBuffer.limit() - n;
        int n3 = charBuffer.arrayOffset();
        int n4 = IndexableBinaryStringTools.getEncodedLength(byteBuffer.array(), n, n2);
        charBuffer.limit(n4 + n3);
        charBuffer.position(0);
        IndexableBinaryStringTools.encode(byteBuffer.array(), n, n2, charBuffer.array(), n3, n4);
    }

    public static void encode(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) {
        assert (n4 == IndexableBinaryStringTools.getEncodedLength(byArray, n, n2));
        if (n2 > 0) {
            CodingCase codingCase;
            int n5 = n;
            int n6 = 0;
            int n7 = n3;
            while (n5 + IndexableBinaryStringTools.CODING_CASES[n6].numBytes <= n2) {
                codingCase = CODING_CASES[n6];
                cArray[n7] = 2 == codingCase.numBytes ? (char)(((byArray[n5] & 0xFF) << codingCase.initialShift) + ((byArray[n5 + 1] & 0xFF) >>> codingCase.finalShift & codingCase.finalMask) & Short.MAX_VALUE) : (char)(((byArray[n5] & 0xFF) << codingCase.initialShift) + ((byArray[n5 + 1] & 0xFF) << codingCase.middleShift) + ((byArray[n5 + 2] & 0xFF) >>> codingCase.finalShift & codingCase.finalMask) & Short.MAX_VALUE);
                n5 += codingCase.advanceBytes;
                if (++n6 == CODING_CASES.length) {
                    n6 = 0;
                }
                ++n7;
            }
            codingCase = CODING_CASES[n6];
            if (n5 + 1 < n2) {
                cArray[n7++] = (char)(((byArray[n5] & 0xFF) << codingCase.initialShift) + ((byArray[n5 + 1] & 0xFF) << codingCase.middleShift) & Short.MAX_VALUE);
                cArray[n7++] = '\u0001';
            } else if (n5 < n2) {
                cArray[n7++] = (char)((byArray[n5] & 0xFF) << codingCase.initialShift & Short.MAX_VALUE);
                cArray[n7++] = n6 == 0 ? (char)'\u0001' : '\u0000';
            } else {
                cArray[n7++] = '\u0001';
            }
        }
    }

    @Deprecated
    public static void decode(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (!charBuffer.hasArray() || !byteBuffer.hasArray()) {
            throw new IllegalArgumentException("Arguments must have backing arrays");
        }
        int n = charBuffer.arrayOffset();
        int n2 = charBuffer.limit() - n;
        int n3 = byteBuffer.arrayOffset();
        int n4 = IndexableBinaryStringTools.getDecodedLength(charBuffer.array(), n, n2);
        byteBuffer.limit(n4 + n3);
        byteBuffer.position(0);
        IndexableBinaryStringTools.decode(charBuffer.array(), n, n2, byteBuffer.array(), n3, n4);
    }

    public static void decode(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        assert (n4 == IndexableBinaryStringTools.getDecodedLength(cArray, n, n2));
        int n5 = n2 - 1;
        int n6 = n4;
        if (n6 > 0) {
            short s;
            CodingCase codingCase;
            int n7;
            int n8 = 0;
            int n9 = n3;
            for (n7 = n; n7 < n5 - 1; ++n7) {
                codingCase = CODING_CASES[n8];
                s = (short)cArray[n7];
                if (2 == codingCase.numBytes) {
                    if (0 == n8) {
                        byArray[n9] = (byte)(s >>> codingCase.initialShift);
                    } else {
                        int n10 = n9;
                        byArray[n10] = (byte)(byArray[n10] + (byte)(s >>> codingCase.initialShift));
                    }
                    byArray[n9 + 1] = (byte)((s & codingCase.finalMask) << codingCase.finalShift);
                } else {
                    int n11 = n9;
                    byArray[n11] = (byte)(byArray[n11] + (byte)(s >>> codingCase.initialShift));
                    byArray[n9 + 1] = (byte)((s & codingCase.middleMask) >>> codingCase.middleShift);
                    byArray[n9 + 2] = (byte)((s & codingCase.finalMask) << codingCase.finalShift);
                }
                n9 += codingCase.advanceBytes;
                if (++n8 != CODING_CASES.length) continue;
                n8 = 0;
            }
            s = (short)cArray[n7];
            codingCase = CODING_CASES[n8];
            if (0 == n8) {
                byArray[n9] = 0;
            }
            int n12 = n9;
            byArray[n12] = (byte)(byArray[n12] + (byte)(s >>> codingCase.initialShift));
            int n13 = n6 - n9;
            if (n13 > 1) {
                if (2 == codingCase.numBytes) {
                    byArray[n9 + 1] = (byte)((s & codingCase.finalMask) >>> codingCase.finalShift);
                } else {
                    byArray[n9 + 1] = (byte)((s & codingCase.middleMask) >>> codingCase.middleShift);
                    if (n13 > 2) {
                        byArray[n9 + 2] = (byte)((s & codingCase.finalMask) << codingCase.finalShift);
                    }
                }
            }
        }
    }

    @Deprecated
    public static ByteBuffer decode(CharBuffer charBuffer) {
        byte[] byArray = new byte[IndexableBinaryStringTools.getDecodedLength(charBuffer)];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        IndexableBinaryStringTools.decode(charBuffer, byteBuffer);
        return byteBuffer;
    }

    @Deprecated
    public static CharBuffer encode(ByteBuffer byteBuffer) {
        char[] cArray = new char[IndexableBinaryStringTools.getEncodedLength(byteBuffer)];
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        IndexableBinaryStringTools.encode(byteBuffer, charBuffer);
        return charBuffer;
    }

    static class CodingCase {
        int numBytes;
        int initialShift;
        int middleShift;
        int finalShift;
        int advanceBytes = 2;
        short middleMask;
        short finalMask;

        CodingCase(int n, int n2, int n3) {
            this.numBytes = 3;
            this.initialShift = n;
            this.middleShift = n2;
            this.finalShift = n3;
            this.finalMask = (short)(255 >>> n3);
            this.middleMask = (short)(255 << n2);
        }

        CodingCase(int n, int n2) {
            this.numBytes = 2;
            this.initialShift = n;
            this.finalShift = n2;
            this.finalMask = (short)(255 >>> n2);
            if (n2 != 0) {
                this.advanceBytes = 1;
            }
        }
    }
}

