/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSetIterator;

public final class FixedBitSet
extends DocIdSet
implements Bits {
    private final long[] bits;
    private int numBits;

    public static int bits2words(int n) {
        int n2 = n >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        return n2;
    }

    public FixedBitSet(int n) {
        this.numBits = n;
        this.bits = new long[FixedBitSet.bits2words(n)];
    }

    public FixedBitSet(FixedBitSet fixedBitSet) {
        this.bits = new long[fixedBitSet.bits.length];
        System.arraycopy(fixedBitSet.bits, 0, this.bits, 0, this.bits.length);
        this.numBits = fixedBitSet.numBits;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new OpenBitSetIterator(this.bits, this.bits.length);
    }

    @Override
    public int length() {
        return this.numBits;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public long[] getBits() {
        return this.bits;
    }

    public int cardinality() {
        return (int)BitUtil.pop_array(this.bits, 0, this.bits.length);
    }

    @Override
    public boolean get(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        return (this.bits[n2] & l) != 0L;
    }

    public void set(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] | l;
    }

    public boolean getAndSet(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        boolean bl = (this.bits[n2] & l) != 0L;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] | l;
        return bl;
    }

    public void clear(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean getAndClear(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = 1L << n3;
        boolean bl = (this.bits[n2] & l) != 0L;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        return bl;
    }

    public int nextSetBit(int n) {
        assert (n >= 0 && n < this.numBits);
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l != 0L) {
            return (n2 << 6) + n3 + BitUtil.ntz(l);
        }
        while (++n2 < this.bits.length) {
            l = this.bits[n2];
            if (l == 0L) continue;
            return (n2 << 6) + BitUtil.ntz(l);
        }
        return -1;
    }

    public int prevSetBit(int n) {
        assert (n >= 0 && n < this.numBits) : "index=" + n + " numBits=" + this.numBits;
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        long l = this.bits[n2] << 63 - n3;
        if (l != 0L) {
            return (n2 << 6) + n3 - Long.numberOfLeadingZeros(l);
        }
        while (--n2 >= 0) {
            l = this.bits[n2];
            if (l == 0L) continue;
            return (n2 << 6) + 63 - Long.numberOfLeadingZeros(l);
        }
        return -1;
    }

    public void or(DocIdSetIterator docIdSetIterator) throws IOException {
        if (docIdSetIterator instanceof OpenBitSetIterator && docIdSetIterator.docID() == -1) {
            OpenBitSetIterator openBitSetIterator = (OpenBitSetIterator)docIdSetIterator;
            this.or(openBitSetIterator.arr, openBitSetIterator.words);
            openBitSetIterator.advance(this.numBits);
        } else {
            int n;
            while ((n = docIdSetIterator.nextDoc()) < this.numBits) {
                this.set(n);
            }
        }
    }

    public void or(FixedBitSet fixedBitSet) {
        this.or(fixedBitSet.bits, fixedBitSet.bits.length);
    }

    private void or(long[] lArray, int n) {
        long[] lArray2 = this.bits;
        int n2 = Math.min(lArray2.length, n);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray2[n3] = lArray2[n3] | lArray[n2];
        }
    }

    public void and(DocIdSetIterator docIdSetIterator) throws IOException {
        if (docIdSetIterator instanceof OpenBitSetIterator && docIdSetIterator.docID() == -1) {
            OpenBitSetIterator openBitSetIterator = (OpenBitSetIterator)docIdSetIterator;
            this.and(openBitSetIterator.arr, openBitSetIterator.words);
            openBitSetIterator.advance(this.numBits);
        } else {
            int n;
            if (this.numBits == 0) {
                return;
            }
            int n2 = this.nextSetBit(0);
            while (n2 != -1 && (n = docIdSetIterator.advance(n2)) < this.numBits) {
                this.clear(n2, n);
                n2 = ++n < this.numBits ? this.nextSetBit(n) : -1;
            }
            if (n2 != -1) {
                this.clear(n2, this.numBits);
            }
        }
    }

    public void and(FixedBitSet fixedBitSet) {
        this.and(fixedBitSet.bits, fixedBitSet.bits.length);
    }

    private void and(long[] lArray, int n) {
        long[] lArray2 = this.bits;
        int n2 = Math.min(lArray2.length, n);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray2[n3] = lArray2[n3] & lArray[n2];
        }
        if (lArray2.length > n) {
            Arrays.fill(lArray2, n, lArray2.length, 0L);
        }
    }

    public void andNot(DocIdSetIterator docIdSetIterator) throws IOException {
        if (docIdSetIterator instanceof OpenBitSetIterator && docIdSetIterator.docID() == -1) {
            OpenBitSetIterator openBitSetIterator = (OpenBitSetIterator)docIdSetIterator;
            this.andNot(openBitSetIterator.arr, openBitSetIterator.words);
            openBitSetIterator.advance(this.numBits);
        } else {
            int n;
            while ((n = docIdSetIterator.nextDoc()) < this.numBits) {
                this.clear(n);
            }
        }
    }

    public void andNot(FixedBitSet fixedBitSet) {
        this.andNot(fixedBitSet.bits, fixedBitSet.bits.length);
    }

    private void andNot(long[] lArray, int n) {
        long[] lArray2 = this.bits;
        int n2 = Math.min(lArray2.length, n);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray2[n3] = lArray2[n3] & (lArray[n2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void flip(int n, int n2) {
        assert (n >= 0 && n < this.numBits);
        assert (n2 >= 0 && n2 <= this.numBits);
        if (n2 <= n) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.bits[n5] = this.bits[n5] ^ l & l2;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] ^ l;
        for (int i = n3 + 1; i < n4; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n7 = n4;
        this.bits[n7] = this.bits[n7] ^ l2;
    }

    public void set(int n, int n2) {
        assert (n >= 0 && n < this.numBits);
        assert (n2 >= 0 && n2 <= this.numBits);
        if (n2 <= n) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            int n5 = n3;
            this.bits[n5] = this.bits[n5] | l & l2;
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] | l;
        Arrays.fill(this.bits, n3 + 1, n4, -1L);
        int n7 = n4;
        this.bits[n7] = this.bits[n7] | l2;
    }

    public void clear(int n, int n2) {
        assert (n >= 0 && n < this.numBits);
        assert (n2 >= 0 && n2 <= this.numBits);
        if (n2 <= n) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        l ^= 0xFFFFFFFFFFFFFFFFL;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        if (n3 == n4) {
            int n5 = n3;
            this.bits[n5] = this.bits[n5] & (l | l2);
            return;
        }
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & l;
        Arrays.fill(this.bits, n3 + 1, n4, 0L);
        int n7 = n4;
        this.bits[n7] = this.bits[n7] & l2;
    }

    public Object clone() {
        return new FixedBitSet(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FixedBitSet)) {
            return false;
        }
        FixedBitSet fixedBitSet = (FixedBitSet)object;
        if (this.numBits != fixedBitSet.length()) {
            return false;
        }
        return Arrays.equals(this.bits, fixedBitSet.bits);
    }

    public int hashCode() {
        long l = 0L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n];
            l = l << 1 | l >>> 63;
        }
        return (int)(l >> 32 ^ l) + -1737092556;
    }
}

