/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MapOfSets;
import org.apache.lucene.util.RamUsageEstimator;

public final class FieldCacheSanityChecker {
    private RamUsageEstimator ramCalc = null;

    public void setRamUsageEstimator(RamUsageEstimator ramUsageEstimator) {
        this.ramCalc = ramUsageEstimator;
    }

    public static Insanity[] checkSanity(FieldCache fieldCache) {
        return FieldCacheSanityChecker.checkSanity(fieldCache.getCacheEntries());
    }

    public static Insanity[] checkSanity(FieldCache.CacheEntry ... cacheEntryArray) {
        FieldCacheSanityChecker fieldCacheSanityChecker = new FieldCacheSanityChecker();
        fieldCacheSanityChecker.setRamUsageEstimator(new RamUsageEstimator(false));
        return fieldCacheSanityChecker.check(cacheEntryArray);
    }

    public Insanity[] check(FieldCache.CacheEntry ... cacheEntryArray) {
        if (null == cacheEntryArray || 0 == cacheEntryArray.length) {
            return new Insanity[0];
        }
        if (null != this.ramCalc) {
            for (int i = 0; i < cacheEntryArray.length; ++i) {
                cacheEntryArray[i].estimateSize(this.ramCalc);
            }
        }
        MapOfSets<Integer, FieldCache.CacheEntry> mapOfSets = new MapOfSets<Integer, FieldCache.CacheEntry>(new HashMap(17));
        MapOfSets<ReaderField, Integer> mapOfSets2 = new MapOfSets<ReaderField, Integer>(new HashMap(17));
        HashSet<ReaderField> hashSet = new HashSet<ReaderField>();
        for (int i = 0; i < cacheEntryArray.length; ++i) {
            FieldCache.CacheEntry cacheEntry = cacheEntryArray[i];
            Object object = cacheEntry.getValue();
            if (object instanceof Bits || object instanceof FieldCache.CreationPlaceholder) continue;
            ReaderField readerField = new ReaderField(cacheEntry.getReaderKey(), cacheEntry.getFieldName());
            Integer n = System.identityHashCode(object);
            mapOfSets.put(n, cacheEntry);
            if (1 >= mapOfSets2.put(readerField, n)) continue;
            hashSet.add(readerField);
        }
        ArrayList<Insanity> arrayList = new ArrayList<Insanity>(hashSet.size() * 3);
        arrayList.addAll(this.checkValueMismatch(mapOfSets, mapOfSets2, hashSet));
        arrayList.addAll(this.checkSubreaders(mapOfSets, mapOfSets2));
        return arrayList.toArray(new Insanity[arrayList.size()]);
    }

    private Collection<Insanity> checkValueMismatch(MapOfSets<Integer, FieldCache.CacheEntry> mapOfSets, MapOfSets<ReaderField, Integer> mapOfSets2, Set<ReaderField> set) {
        ArrayList<Insanity> arrayList = new ArrayList<Insanity>(set.size() * 3);
        if (!set.isEmpty()) {
            Map<ReaderField, Set<Integer>> map = mapOfSets2.getMap();
            Map<Integer, Set<FieldCache.CacheEntry>> map2 = mapOfSets.getMap();
            for (ReaderField readerField : set) {
                ArrayList<FieldCache.CacheEntry> arrayList2 = new ArrayList<FieldCache.CacheEntry>(set.size() * 2);
                for (Integer n : map.get(readerField)) {
                    for (FieldCache.CacheEntry cacheEntry : map2.get(n)) {
                        arrayList2.add(cacheEntry);
                    }
                }
                FieldCache.CacheEntry[] cacheEntryArray = new FieldCache.CacheEntry[arrayList2.size()];
                cacheEntryArray = arrayList2.toArray(cacheEntryArray);
                arrayList.add(new Insanity(InsanityType.VALUEMISMATCH, "Multiple distinct value objects for " + readerField.toString(), cacheEntryArray));
            }
        }
        return arrayList;
    }

    private Collection<Insanity> checkSubreaders(MapOfSets<Integer, FieldCache.CacheEntry> mapOfSets, MapOfSets<ReaderField, Integer> mapOfSets2) {
        Collection<Object> collection;
        ArrayList<Insanity> arrayList = new ArrayList<Insanity>(23);
        HashMap hashMap = new HashMap(17);
        MapOfSets<ReaderField, ReaderField> mapOfSets3 = new MapOfSets<ReaderField, ReaderField>(hashMap);
        Map<Integer, Set<FieldCache.CacheEntry>> map = mapOfSets.getMap();
        Map<ReaderField, Set<Integer>> map2 = mapOfSets2.getMap();
        HashSet<ReaderField> hashSet = new HashSet<ReaderField>(17);
        Set<ReaderField> set = map2.keySet();
        for (ReaderField readerField : set) {
            if (hashSet.contains(readerField)) continue;
            collection = this.getAllDescendantReaderKeys(readerField.readerKey);
            for (Object iterator : collection) {
                ReaderField readerField2 = new ReaderField(iterator, readerField.fieldName);
                if (hashMap.containsKey(readerField2)) {
                    mapOfSets3.put(readerField, readerField2);
                    mapOfSets3.putAll(readerField, (Collection)hashMap.get(readerField2));
                    hashMap.remove(readerField2);
                } else if (map2.containsKey(readerField2)) {
                    mapOfSets3.put(readerField, readerField2);
                }
                hashSet.add(readerField2);
            }
            hashSet.add(readerField);
        }
        for (ReaderField readerField : hashMap.keySet()) {
            collection = (Set)hashMap.get(readerField);
            ArrayList arrayList2 = new ArrayList(collection.size() * 2);
            for (Integer n : map2.get(readerField)) {
                arrayList2.addAll(map.get(n));
            }
            for (ReaderField readerField3 : collection) {
                for (Integer n : map2.get(readerField3)) {
                    arrayList2.addAll(map.get(n));
                }
            }
            FieldCache.CacheEntry[] cacheEntryArray2 = new FieldCache.CacheEntry[arrayList2.size()];
            cacheEntryArray2 = arrayList2.toArray(cacheEntryArray2);
            arrayList.add(new Insanity(InsanityType.SUBREADER, "Found caches for descendants of " + readerField.toString(), cacheEntryArray2));
        }
        return arrayList;
    }

    private List<Object> getAllDescendantReaderKeys(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(17);
        arrayList.add(object);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof IndexReader)) continue;
            IndexReader[] indexReaderArray = ((IndexReader)e).getSequentialSubReaders();
            for (int j = 0; null != indexReaderArray && j < indexReaderArray.length; ++j) {
                arrayList.add(indexReaderArray[j].getCoreCacheKey());
            }
        }
        return arrayList.subList(1, arrayList.size());
    }

    public static final class InsanityType {
        private final String label;
        public static final InsanityType SUBREADER = new InsanityType("SUBREADER");
        public static final InsanityType VALUEMISMATCH = new InsanityType("VALUEMISMATCH");
        public static final InsanityType EXPECTED = new InsanityType("EXPECTED");

        private InsanityType(String string) {
            this.label = string;
        }

        public String toString() {
            return this.label;
        }
    }

    public static final class Insanity {
        private final InsanityType type;
        private final String msg;
        private final FieldCache.CacheEntry[] entries;

        public Insanity(InsanityType insanityType, String string, FieldCache.CacheEntry ... cacheEntryArray) {
            if (null == insanityType) {
                throw new IllegalArgumentException("Insanity requires non-null InsanityType");
            }
            if (null == cacheEntryArray || 0 == cacheEntryArray.length) {
                throw new IllegalArgumentException("Insanity requires non-null/non-empty CacheEntry[]");
            }
            this.type = insanityType;
            this.msg = string;
            this.entries = cacheEntryArray;
        }

        public InsanityType getType() {
            return this.type;
        }

        public String getMsg() {
            return this.msg;
        }

        public FieldCache.CacheEntry[] getCacheEntries() {
            return this.entries;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getType()).append(": ");
            String string = this.getMsg();
            if (null != string) {
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
            FieldCache.CacheEntry[] cacheEntryArray = this.getCacheEntries();
            for (int i = 0; i < cacheEntryArray.length; ++i) {
                stringBuilder.append('\t').append(cacheEntryArray[i].toString()).append('\n');
            }
            return stringBuilder.toString();
        }
    }

    private static final class ReaderField {
        public final Object readerKey;
        public final String fieldName;

        public ReaderField(Object object, String string) {
            this.readerKey = object;
            this.fieldName = string;
        }

        public int hashCode() {
            return System.identityHashCode(this.readerKey) * this.fieldName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ReaderField)) {
                return false;
            }
            ReaderField readerField = (ReaderField)object;
            return this.readerKey == readerField.readerKey && this.fieldName.equals(readerField.fieldName);
        }

        public String toString() {
            return this.readerKey.toString() + "+" + this.fieldName;
        }
    }
}

