/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.UnicodeUtil;

public final class BytesRef
implements Comparable<BytesRef> {
    static final int HASH_PRIME = 31;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;
    private static final Comparator<BytesRef> utf8SortedAsUnicodeSortOrder = new UTF8SortedAsUnicodeComparator();
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = new UTF8SortedAsUTF16Comparator();

    public BytesRef() {
        this.bytes = EMPTY_BYTES;
    }

    public BytesRef(byte[] byArray, int n, int n2) {
        assert (byArray != null);
        this.bytes = byArray;
        this.offset = n;
        this.length = n2;
    }

    public BytesRef(byte[] byArray) {
        assert (byArray != null);
        this.bytes = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public BytesRef(int n) {
        this.bytes = new byte[n];
    }

    public BytesRef(CharSequence charSequence) {
        this();
        this.copy(charSequence);
    }

    public BytesRef(char[] cArray, int n, int n2) {
        this(n2 * 4);
        this.copy(cArray, n, n2);
    }

    public BytesRef(BytesRef bytesRef) {
        this();
        this.copy(bytesRef);
    }

    public void copy(CharSequence charSequence) {
        UnicodeUtil.UTF16toUTF8(charSequence, 0, charSequence.length(), this);
    }

    public void copy(char[] cArray, int n, int n2) {
        UnicodeUtil.UTF16toUTF8(cArray, n, n2, this);
    }

    public boolean bytesEquals(BytesRef bytesRef) {
        if (this.length == bytesRef.length) {
            int n = bytesRef.offset;
            byte[] byArray = bytesRef.bytes;
            int n2 = this.offset + this.length;
            int n3 = this.offset;
            while (n3 < n2) {
                if (this.bytes[n3] != byArray[n]) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new BytesRef(this);
    }

    private boolean sliceEquals(BytesRef bytesRef, int n) {
        if (n < 0 || this.length - n < bytesRef.length) {
            return false;
        }
        int n2 = this.offset + n;
        int n3 = bytesRef.offset;
        int n4 = bytesRef.offset + bytesRef.length;
        while (n3 < n4) {
            if (this.bytes[n2++] == bytesRef.bytes[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(BytesRef bytesRef) {
        return this.sliceEquals(bytesRef, 0);
    }

    public boolean endsWith(BytesRef bytesRef) {
        return this.sliceEquals(bytesRef, this.length - bytesRef.length);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset + this.length;
        for (int i = this.offset; i < n2; ++i) {
            n = 31 * n + this.bytes[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.bytesEquals((BytesRef)object);
    }

    public String utf8ToString() {
        try {
            return new String(this.bytes, this.offset, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.offset + this.length;
        for (int i = this.offset; i < n; ++i) {
            if (i > this.offset) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(this.bytes[i] & 0xFF));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void copy(BytesRef bytesRef) {
        if (this.bytes.length < bytesRef.length) {
            this.bytes = new byte[bytesRef.length];
        }
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.bytes, 0, bytesRef.length);
        this.length = bytesRef.length;
        this.offset = 0;
    }

    public void append(BytesRef bytesRef) {
        int n = this.length + bytesRef.length;
        if (this.bytes.length < n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, this.offset, byArray, 0, this.length);
            this.offset = 0;
            this.bytes = byArray;
        }
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.bytes, this.length + this.offset, bytesRef.length);
        this.length = n;
    }

    public void grow(int n) {
        this.bytes = ArrayUtil.grow(this.bytes, n);
    }

    @Override
    public int compareTo(BytesRef bytesRef) {
        if (this == bytesRef) {
            return 0;
        }
        byte[] byArray = this.bytes;
        int n = this.offset;
        byte[] byArray2 = bytesRef.bytes;
        int n2 = bytesRef.offset;
        int n3 = n + Math.min(this.length, bytesRef.length);
        while (n < n3) {
            int n4;
            int n5;
            int n6;
            if ((n6 = (n5 = byArray[n++] & 0xFF) - (n4 = byArray2[n2++] & 0xFF)) == 0) continue;
            return n6;
        }
        return this.length - bytesRef.length;
    }

    public static Comparator<BytesRef> getUTF8SortedAsUnicodeComparator() {
        return utf8SortedAsUnicodeSortOrder;
    }

    public static Comparator<BytesRef> getUTF8SortedAsUTF16Comparator() {
        return utf8SortedAsUTF16SortOrder;
    }

    private static class UTF8SortedAsUTF16Comparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUTF16Comparator() {
        }

        @Override
        public int compare(BytesRef bytesRef, BytesRef bytesRef2) {
            byte[] byArray = bytesRef.bytes;
            int n = bytesRef.offset;
            byte[] byArray2 = bytesRef2.bytes;
            int n2 = bytesRef2.offset;
            int n3 = bytesRef.length < bytesRef2.length ? n + bytesRef.length : n + bytesRef2.length;
            while (n < n3) {
                int n4;
                int n5;
                if ((n5 = byArray[n++] & 0xFF) == (n4 = byArray2[n2++] & 0xFF)) continue;
                if (n5 >= 238 && n4 >= 238) {
                    if ((n5 & 0xFE) == 238) {
                        n5 += 14;
                    }
                    if ((n4 & 0xFE) == 238) {
                        n4 += 14;
                    }
                }
                return n5 - n4;
            }
            return bytesRef.length - bytesRef2.length;
        }
    }

    private static class UTF8SortedAsUnicodeComparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUnicodeComparator() {
        }

        @Override
        public int compare(BytesRef bytesRef, BytesRef bytesRef2) {
            byte[] byArray = bytesRef.bytes;
            int n = bytesRef.offset;
            byte[] byArray2 = bytesRef2.bytes;
            int n2 = bytesRef2.offset;
            int n3 = bytesRef.length < bytesRef2.length ? n + bytesRef.length : n + bytesRef2.length;
            while (n < n3) {
                int n4;
                int n5;
                int n6;
                if ((n6 = (n5 = byArray[n++] & 0xFF) - (n4 = byArray2[n2++] & 0xFF)) == 0) continue;
                return n6;
            }
            return bytesRef.length - bytesRef2.length;
        }
    }
}

