/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMInputStream
extends IndexInput
implements Cloneable {
    static final int BUFFER_SIZE = 1024;
    private RAMFile file;
    private long length;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    @Deprecated
    public RAMInputStream(RAMFile rAMFile) throws IOException {
        this("anonymous", rAMFile);
    }

    public RAMInputStream(String string, RAMFile rAMFile) throws IOException {
        super("RAMInputStream(name=" + string + ")");
        this.file = rAMFile;
        this.length = this.file.length;
        if (this.length / 1024L >= Integer.MAX_VALUE) {
            throw new IOException("RAMInputStream too large length=" + this.length + ": " + string);
        }
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer(true);
        }
        return this.currentBuffer[this.bufferPosition++];
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            if (this.bufferPosition >= this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            int n4 = n2 < (n3 = this.bufferLength - this.bufferPosition) ? n2 : n3;
            System.arraycopy(this.currentBuffer, this.bufferPosition, byArray, n, n4);
            n += n4;
            n2 -= n4;
            this.bufferPosition += n4;
        }
    }

    private final void switchCurrentBuffer(boolean bl) throws IOException {
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        if (this.currentBufferIndex >= this.file.numBuffers()) {
            if (bl) {
                throw new EOFException("Read past EOF (resource: " + this + ")");
            }
            --this.currentBufferIndex;
            this.bufferPosition = 1024;
        } else {
            this.currentBuffer = this.file.getBuffer(this.currentBufferIndex);
            this.bufferPosition = 0;
            long l = this.length - this.bufferStart;
            this.bufferLength = l > 1024L ? 1024 : (int)l;
        }
    }

    @Override
    public void copyBytes(IndexOutput indexOutput, long l) throws IOException {
        long l2;
        int n;
        assert (l >= 0L) : "numBytes=" + l;
        for (l2 = l; l2 > 0L; l2 -= (long)n) {
            int n2;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            n = (int)((long)(n2 = this.bufferLength - this.bufferPosition) < l2 ? (long)n2 : l2);
            indexOutput.writeBytes(this.currentBuffer, this.bufferPosition, n);
            this.bufferPosition += n;
        }
        assert (l2 == 0L) : "Insufficient bytes to copy: numBytes=" + l + " copied=" + (l - l2);
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long l) throws IOException {
        if (this.currentBuffer == null || l < this.bufferStart || l >= this.bufferStart + 1024L) {
            this.currentBufferIndex = (int)(l / 1024L);
            this.switchCurrentBuffer(false);
        }
        this.bufferPosition = (int)(l % 1024L);
    }
}

