/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NoSuchDirectoryException;

public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set<String> set, Directory directory, Directory directory2, boolean bl) {
        this.primaryExtensions = set;
        this.primaryDir = directory;
        this.secondaryDir = directory2;
        this.doClose = bl;
        this.lockFactory = directory.getLockFactory();
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
            }
            finally {
                this.primaryDir.close();
            }
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        NoSuchDirectoryException noSuchDirectoryException;
        HashSet<String> hashSet;
        block8: {
            hashSet = new HashSet<String>();
            noSuchDirectoryException = null;
            try {
                for (String string : this.primaryDir.listAll()) {
                    hashSet.add(string);
                }
            }
            catch (NoSuchDirectoryException noSuchDirectoryException2) {
                noSuchDirectoryException = noSuchDirectoryException2;
            }
            try {
                for (String string : this.secondaryDir.listAll()) {
                    hashSet.add(string);
                }
            }
            catch (NoSuchDirectoryException noSuchDirectoryException3) {
                if (noSuchDirectoryException != null) {
                    throw noSuchDirectoryException;
                }
                if (!hashSet.isEmpty()) break block8;
                throw noSuchDirectoryException3;
            }
        }
        if (noSuchDirectoryException != null && hashSet.isEmpty()) {
            throw noSuchDirectoryException;
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1, string.length());
    }

    private Directory getDirectory(String string) {
        String string2 = FileSwitchDirectory.getExtension(string);
        if (this.primaryExtensions.contains(string2)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public boolean fileExists(String string) throws IOException {
        return this.getDirectory(string).fileExists(string);
    }

    @Override
    public long fileModified(String string) throws IOException {
        return this.getDirectory(string).fileModified(string);
    }

    @Override
    @Deprecated
    public void touchFile(String string) throws IOException {
        this.getDirectory(string).touchFile(string);
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.getDirectory(string).deleteFile(string);
    }

    @Override
    public long fileLength(String string) throws IOException {
        return this.getDirectory(string).fileLength(string);
    }

    @Override
    public IndexOutput createOutput(String string) throws IOException {
        return this.getDirectory(string).createOutput(string);
    }

    @Override
    @Deprecated
    public void sync(String string) throws IOException {
        this.sync(Collections.singleton(string));
    }

    @Override
    public void sync(Collection<String> collection) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : collection) {
            if (this.primaryExtensions.contains(FileSwitchDirectory.getExtension(string))) {
                arrayList.add(string);
                continue;
            }
            arrayList2.add(string);
        }
        this.primaryDir.sync(arrayList);
        this.secondaryDir.sync(arrayList2);
    }

    @Override
    public IndexInput openInput(String string) throws IOException {
        return this.getDirectory(string).openInput(string);
    }
}

