/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexOutput;

public class ChecksumIndexOutput
extends IndexOutput {
    IndexOutput main;
    Checksum digest;

    public ChecksumIndexOutput(IndexOutput indexOutput) {
        this.main = indexOutput;
        this.digest = new CRC32();
    }

    @Override
    public void writeByte(byte by) throws IOException {
        this.digest.update(by);
        this.main.writeByte(by);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.digest.update(byArray, n, n2);
        this.main.writeBytes(byArray, n, n2);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void flush() throws IOException {
        this.main.flush();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public void seek(long l) {
        throw new RuntimeException("not allowed");
    }

    public void prepareCommit() throws IOException {
        long l = this.getChecksum();
        long l2 = this.main.getFilePointer();
        this.main.writeLong(l - 1L);
        this.main.flush();
        this.main.seek(l2);
    }

    public void finishCommit() throws IOException {
        this.main.writeLong(this.getChecksum());
    }

    @Override
    public long length() throws IOException {
        return this.main.length();
    }
}

