/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataOutput(byte[] byArray) {
        this.reset(byArray);
    }

    public ByteArrayDataOutput(byte[] byArray, int n, int n2) {
        this.reset(byArray, n, n2);
    }

    public ByteArrayDataOutput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] byArray) {
        this.reset(byArray, 0, byArray.length);
    }

    public void reset(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.pos = n;
        this.limit = n + n2;
    }

    public int getPosition() {
        return this.pos;
    }

    @Override
    public void writeByte(byte by) {
        assert (this.pos < this.limit);
        this.bytes[this.pos++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) {
        assert (this.pos + n2 <= this.limit);
        System.arraycopy(byArray, n, this.bytes, this.pos, n2);
        this.pos += n2;
    }
}

