/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.spans.Spans;

public class TermSpans
extends Spans {
    protected TermPositions positions;
    protected Term term;
    protected int doc;
    protected int freq;
    protected int count;
    protected int position;

    public TermSpans(TermPositions termPositions, Term term) throws IOException {
        this.positions = termPositions;
        this.term = term;
        this.doc = -1;
    }

    @Override
    public boolean next() throws IOException {
        if (this.count == this.freq) {
            if (!this.positions.next()) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
            this.doc = this.positions.doc();
            this.freq = this.positions.freq();
            this.count = 0;
        }
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    @Override
    public boolean skipTo(int n) throws IOException {
        if (!this.positions.skipTo(n)) {
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.positions.doc();
        this.freq = this.positions.freq();
        this.count = 0;
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int start() {
        return this.position;
    }

    @Override
    public int end() {
        return this.position + 1;
    }

    @Override
    public Collection<byte[]> getPayload() throws IOException {
        byte[] byArray = new byte[this.positions.getPayloadLength()];
        byArray = this.positions.getPayload(byArray, 0);
        return Collections.singletonList(byArray);
    }

    @Override
    public boolean isPayloadAvailable() {
        return this.positions.isPayloadAvailable();
    }

    public String toString() {
        return "spans(" + this.term.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "-" + this.position));
    }

    public TermPositions getPositions() {
        return this.positions;
    }
}

