/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.search.TopTermsRewrite;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanMultiTermQueryWrapper<Q extends MultiTermQuery>
extends SpanQuery {
    protected final Q query;
    private Method getFieldMethod = null;
    private Method getTermMethod = null;
    public static final SpanRewriteMethod SCORING_SPAN_QUERY_REWRITE = new SpanRewriteMethod(){
        private final ScoringRewrite<SpanOrQuery> delegate = new ScoringRewrite<SpanOrQuery>(){

            @Override
            protected SpanOrQuery getTopLevelQuery() {
                return new SpanOrQuery(new SpanQuery[0]);
            }

            @Override
            protected void addClause(SpanOrQuery spanOrQuery, Term term, float f) {
                SpanTermQuery spanTermQuery = new SpanTermQuery(term);
                spanTermQuery.setBoost(f);
                spanOrQuery.addClause(spanTermQuery);
            }
        };

        @Override
        public SpanQuery rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
            return this.delegate.rewrite(indexReader, multiTermQuery);
        }

        protected Object readResolve() {
            return SCORING_SPAN_QUERY_REWRITE;
        }
    };

    public SpanMultiTermQueryWrapper(Q q) {
        this.query = q;
        MultiTermQuery.RewriteMethod rewriteMethod = ((MultiTermQuery)q).getRewriteMethod();
        if (rewriteMethod instanceof TopTermsRewrite) {
            int n = ((TopTermsRewrite)rewriteMethod).getSize();
            this.setRewriteMethod(new TopTermsSpanBooleanQueryRewrite(n));
        } else {
            this.setRewriteMethod(SCORING_SPAN_QUERY_REWRITE);
        }
        try {
            this.getFieldMethod = q.getClass().getMethod("getField", new Class[0]);
        }
        catch (Exception exception) {
            try {
                this.getTermMethod = q.getClass().getMethod("getTerm", new Class[0]);
            }
            catch (Exception exception2) {
                try {
                    this.getTermMethod = q.getClass().getMethod("getPrefix", new Class[0]);
                }
                catch (Exception exception3) {
                    throw new IllegalArgumentException("SpanMultiTermQueryWrapper can only wrap MultiTermQueries that can return a field name using getField() or getTerm()");
                }
            }
        }
    }

    public final SpanRewriteMethod getRewriteMethod() {
        MultiTermQuery.RewriteMethod rewriteMethod = ((MultiTermQuery)this.query).getRewriteMethod();
        if (!(rewriteMethod instanceof SpanRewriteMethod)) {
            throw new UnsupportedOperationException("You can only use SpanMultiTermQueryWrapper with a suitable SpanRewriteMethod.");
        }
        return (SpanRewriteMethod)rewriteMethod;
    }

    public final void setRewriteMethod(SpanRewriteMethod spanRewriteMethod) {
        ((MultiTermQuery)this.query).setRewriteMethod(spanRewriteMethod);
    }

    @Override
    public Spans getSpans(IndexReader indexReader) throws IOException {
        throw new UnsupportedOperationException("Query should have been rewritten");
    }

    @Override
    public String getField() {
        try {
            if (this.getFieldMethod != null) {
                return (String)this.getFieldMethod.invoke(this.query, new Object[0]);
            }
            assert (this.getTermMethod != null);
            return ((Term)this.getTermMethod.invoke(this.query, new Object[0])).field();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot invoke getField() or getTerm() on wrapped query.", exception);
        }
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SpanMultiTermQueryWrapper(");
        stringBuilder.append(((Query)this.query).toString(string));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Query query = ((MultiTermQuery)this.query).rewrite(indexReader);
        if (!(query instanceof SpanQuery)) {
            throw new UnsupportedOperationException("You can only use SpanMultiTermQueryWrapper with a suitable SpanRewriteMethod.");
        }
        return query;
    }

    @Override
    public int hashCode() {
        return 31 * ((MultiTermQuery)this.query).hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SpanMultiTermQueryWrapper spanMultiTermQueryWrapper = (SpanMultiTermQueryWrapper)object;
        return ((MultiTermQuery)this.query).equals(spanMultiTermQueryWrapper.query);
    }

    public static final class TopTermsSpanBooleanQueryRewrite
    extends SpanRewriteMethod {
        private final TopTermsRewrite<SpanOrQuery> delegate;

        public TopTermsSpanBooleanQueryRewrite(int n) {
            this.delegate = new TopTermsRewrite<SpanOrQuery>(n){

                @Override
                protected int getMaxSize() {
                    return Integer.MAX_VALUE;
                }

                @Override
                protected SpanOrQuery getTopLevelQuery() {
                    return new SpanOrQuery(new SpanQuery[0]);
                }

                @Override
                protected void addClause(SpanOrQuery spanOrQuery, Term term, float f) {
                    SpanTermQuery spanTermQuery = new SpanTermQuery(term);
                    spanTermQuery.setBoost(f);
                    spanOrQuery.addClause(spanTermQuery);
                }
            };
        }

        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public SpanQuery rewrite(IndexReader indexReader, MultiTermQuery multiTermQuery) throws IOException {
            return this.delegate.rewrite(indexReader, multiTermQuery);
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TopTermsSpanBooleanQueryRewrite topTermsSpanBooleanQueryRewrite = (TopTermsSpanBooleanQueryRewrite)object;
            return this.delegate.equals(topTermsSpanBooleanQueryRewrite.delegate);
        }
    }

    public static abstract class SpanRewriteMethod
    extends MultiTermQuery.RewriteMethod {
        @Override
        public abstract SpanQuery rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }
}

