/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanPositionRangeQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanFirstQuery
extends SpanPositionRangeQuery {
    public SpanFirstQuery(SpanQuery spanQuery, int n) {
        super(spanQuery, 0, n);
    }

    @Override
    protected SpanPositionCheckQuery.AcceptStatus acceptPosition(Spans spans) throws IOException {
        assert (spans.start() != spans.end());
        if (spans.start() >= this.end) {
            return SpanPositionCheckQuery.AcceptStatus.NO_AND_ADVANCE;
        }
        if (spans.end() <= this.end) {
            return SpanPositionCheckQuery.AcceptStatus.YES;
        }
        return SpanPositionCheckQuery.AcceptStatus.NO;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanFirst(");
        stringBuilder.append(this.match.toString(string));
        stringBuilder.append(", ");
        stringBuilder.append(this.end);
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        SpanFirstQuery spanFirstQuery = new SpanFirstQuery((SpanQuery)this.match.clone(), this.end);
        spanFirstQuery.setBoost(this.getBoost());
        return spanFirstQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanFirstQuery)) {
            return false;
        }
        SpanFirstQuery spanFirstQuery = (SpanFirstQuery)object;
        return this.end == spanFirstQuery.end && this.match.equals(spanFirstQuery.match) && this.getBoost() == spanFirstQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = this.match.hashCode();
        n ^= n << 8 | n >>> 25;
        return n ^= Float.floatToRawIntBits(this.getBoost()) ^ this.end;
    }
}

