/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.payloads.AveragePayloadFunction;
import org.apache.lucene.search.payloads.PayloadFunction;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.NearSpansUnordered;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class PayloadNearQuery
extends SpanNearQuery {
    protected String fieldName;
    protected PayloadFunction function;

    public PayloadNearQuery(SpanQuery[] spanQueryArray, int n, boolean bl) {
        this(spanQueryArray, n, bl, new AveragePayloadFunction());
    }

    public PayloadNearQuery(SpanQuery[] spanQueryArray, int n, boolean bl, PayloadFunction payloadFunction) {
        super(spanQueryArray, n, bl);
        this.fieldName = spanQueryArray[0].getField();
        this.function = payloadFunction;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new PayloadNearSpanWeight(this, searcher);
    }

    @Override
    public Object clone() {
        int n = this.clauses.size();
        SpanQuery[] spanQueryArray = new SpanQuery[n];
        for (int i = 0; i < n; ++i) {
            spanQueryArray[i] = (SpanQuery)((SpanQuery)this.clauses.get(i)).clone();
        }
        PayloadNearQuery payloadNearQuery = new PayloadNearQuery(spanQueryArray, this.slop, this.inOrder, this.function);
        payloadNearQuery.setBoost(this.getBoost());
        return payloadNearQuery;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("payloadNear([");
        Iterator iterator = this.clauses.iterator();
        while (iterator.hasNext()) {
            SpanQuery spanQuery = (SpanQuery)iterator.next();
            stringBuilder.append(spanQuery.toString(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("], ");
        stringBuilder.append(this.slop);
        stringBuilder.append(", ");
        stringBuilder.append(this.inOrder);
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        n = 31 * n + (this.function == null ? 0 : this.function.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PayloadNearQuery payloadNearQuery = (PayloadNearQuery)object;
        if (this.fieldName == null ? payloadNearQuery.fieldName != null : !this.fieldName.equals(payloadNearQuery.fieldName)) {
            return false;
        }
        return !(this.function == null ? payloadNearQuery.function != null : !this.function.equals(payloadNearQuery.function));
    }

    public class PayloadNearSpanScorer
    extends SpanScorer {
        Spans spans;
        protected float payloadScore;
        private int payloadsSeen;
        Similarity similarity;

        protected PayloadNearSpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] byArray) throws IOException {
            super(spans, weight, similarity, byArray);
            this.similarity = this.getSimilarity();
            this.spans = spans;
        }

        public void getPayloads(Spans[] spansArray) throws IOException {
            for (int i = 0; i < spansArray.length; ++i) {
                if (spansArray[i] instanceof NearSpansOrdered) {
                    if (((NearSpansOrdered)spansArray[i]).isPayloadAvailable()) {
                        this.processPayloads(((NearSpansOrdered)spansArray[i]).getPayload(), spansArray[i].start(), spansArray[i].end());
                    }
                    this.getPayloads(((NearSpansOrdered)spansArray[i]).getSubSpans());
                    continue;
                }
                if (!(spansArray[i] instanceof NearSpansUnordered)) continue;
                if (((NearSpansUnordered)spansArray[i]).isPayloadAvailable()) {
                    this.processPayloads(((NearSpansUnordered)spansArray[i]).getPayload(), spansArray[i].start(), spansArray[i].end());
                }
                this.getPayloads(((NearSpansUnordered)spansArray[i]).getSubSpans());
            }
        }

        protected void processPayloads(Collection<byte[]> collection, int n, int n2) {
            for (byte[] byArray : collection) {
                this.payloadScore = PayloadNearQuery.this.function.currentScore(this.doc, PayloadNearQuery.this.fieldName, n, n2, this.payloadsSeen, this.payloadScore, this.similarity.scorePayload(this.doc, PayloadNearQuery.this.fieldName, this.spans.start(), this.spans.end(), byArray, 0, byArray.length));
                ++this.payloadsSeen;
            }
        }

        @Override
        protected boolean setFreqCurrentDoc() throws IOException {
            if (!this.more) {
                return false;
            }
            this.doc = this.spans.doc();
            this.freq = 0.0f;
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
            do {
                int n = this.spans.end() - this.spans.start();
                this.freq += this.getSimilarity().sloppyFreq(n);
                Spans[] spansArray = new Spans[]{this.spans};
                this.getPayloads(spansArray);
                this.more = this.spans.next();
            } while (this.more && this.doc == this.spans.doc());
            return true;
        }

        @Override
        public float score() throws IOException {
            return super.score() * PayloadNearQuery.this.function.docScore(this.doc, PayloadNearQuery.this.fieldName, this.payloadsSeen, this.payloadScore);
        }

        @Override
        protected Explanation explain(int n) throws IOException {
            Explanation explanation = new Explanation();
            Explanation explanation2 = super.explain(n);
            explanation.addDetail(explanation2);
            Explanation explanation3 = PayloadNearQuery.this.function.explain(n, this.payloadsSeen, this.payloadScore);
            explanation.addDetail(explanation3);
            explanation.setValue(explanation2.getValue() * explanation3.getValue());
            explanation.setDescription("PayloadNearQuery, product of:");
            return explanation;
        }
    }

    public class PayloadNearSpanWeight
    extends SpanWeight {
        public PayloadNearSpanWeight(SpanQuery spanQuery, Searcher searcher) throws IOException {
            super(spanQuery, searcher);
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            return new PayloadNearSpanScorer(this.query.getSpans(indexReader), this, this.similarity, indexReader.norms(this.query.getField()));
        }
    }
}

