/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;

public class OrdFieldSource
extends ValueSource {
    protected String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public OrdFieldSource(String string) {
        this.field = string;
    }

    @Override
    public String description() {
        return "ord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(IndexReader indexReader) throws IOException {
        final int[] nArray = FieldCache.DEFAULT.getStringIndex((IndexReader)indexReader, (String)this.field).order;
        return new DocValues(){

            @Override
            public float floatVal(int n) {
                return nArray[n];
            }

            @Override
            public String strVal(int n) {
                return Integer.toString(nArray[n]);
            }

            @Override
            public String toString(int n) {
                return OrdFieldSource.this.description() + '=' + this.intVal(n);
            }

            @Override
            Object getInnerArray() {
                return nArray;
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != OrdFieldSource.class) {
            return false;
        }
        OrdFieldSource ordFieldSource = (OrdFieldSource)object;
        return this.field.equals(ordFieldSource.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

