/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import org.apache.lucene.search.function.ByteFieldSource;
import org.apache.lucene.search.function.FloatFieldSource;
import org.apache.lucene.search.function.IntFieldSource;
import org.apache.lucene.search.function.ShortFieldSource;
import org.apache.lucene.search.function.ValueSource;
import org.apache.lucene.search.function.ValueSourceQuery;

public class FieldScoreQuery
extends ValueSourceQuery {
    public FieldScoreQuery(String string, Type type) {
        super(FieldScoreQuery.getValueSource(string, type));
    }

    private static ValueSource getValueSource(String string, Type type) {
        if (type == Type.BYTE) {
            return new ByteFieldSource(string);
        }
        if (type == Type.SHORT) {
            return new ShortFieldSource(string);
        }
        if (type == Type.INT) {
            return new IntFieldSource(string);
        }
        if (type == Type.FLOAT) {
            return new FloatFieldSource(string);
        }
        throw new IllegalArgumentException(type + " is not a known Field Score Query Type!");
    }

    public static class Type {
        public static final Type BYTE = new Type("byte");
        public static final Type SHORT = new Type("short");
        public static final Type INT = new Type("int");
        public static final Type FLOAT = new Type("float");
        private String typeName;

        private Type(String string) {
            this.typeName = string;
        }

        public String toString() {
            return this.getClass().getName() + "::" + this.typeName;
        }
    }
}

