/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class ByteFieldSource
extends FieldCacheSource {
    private FieldCache.ByteParser parser;

    public ByteFieldSource(String string) {
        this(string, null);
    }

    public ByteFieldSource(String string, FieldCache.ByteParser byteParser) {
        super(string);
        this.parser = byteParser;
    }

    @Override
    public String description() {
        return "byte(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache fieldCache, String string, IndexReader indexReader) throws IOException {
        final byte[] byArray = fieldCache.getBytes(indexReader, string, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int n) {
                return byArray[n];
            }

            @Override
            public int intVal(int n) {
                return byArray[n];
            }

            @Override
            public String toString(int n) {
                return ByteFieldSource.this.description() + '=' + this.intVal(n);
            }

            @Override
            Object getInnerArray() {
                return byArray;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource fieldCacheSource) {
        if (fieldCacheSource.getClass() != ByteFieldSource.class) {
            return false;
        }
        ByteFieldSource byteFieldSource = (ByteFieldSource)fieldCacheSource;
        return this.parser == null ? byteFieldSource.parser == null : this.parser.getClass() == byteFieldSource.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Byte.class.hashCode() : this.parser.getClass().hashCode();
    }
}

