/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.search.SingleTermEnum;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.util.ToStringUtils;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;
    private boolean termIsPrefix;
    protected Term term;

    public WildcardQuery(Term term) {
        this.term = term;
        String string = term.text();
        this.termContainsWildcard = string.indexOf(42) != -1 || string.indexOf(63) != -1;
        this.termIsPrefix = this.termContainsWildcard && string.indexOf(63) == -1 && string.indexOf(42) == string.length() - 1;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader indexReader) throws IOException {
        if (this.termIsPrefix) {
            return new PrefixTermEnum(indexReader, this.term.createTerm(this.term.text().substring(0, this.term.text().indexOf(42))));
        }
        if (this.termContainsWildcard) {
            return new WildcardTermEnum(indexReader, this.getTerm());
        }
        return new SingleTermEnum(indexReader, this.getTerm());
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.term == null ? 0 : this.term.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WildcardQuery wildcardQuery = (WildcardQuery)object;
        return !(this.term == null ? wildcardQuery.term != null : !this.term.equals(wildcardQuery.term));
    }
}

