/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;

public class SearcherLifetimeManager
implements Closeable {
    private volatile boolean closed;
    private final ConcurrentHashMap<Long, SearcherTracker> searchers = new ConcurrentHashMap();

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("this SearcherLifetimeManager instance is closed");
        }
    }

    public long record(IndexSearcher indexSearcher) throws IOException {
        this.ensureOpen();
        long l = indexSearcher.getIndexReader().getVersion();
        SearcherTracker searcherTracker = this.searchers.get(l);
        if (searcherTracker == null) {
            searcherTracker = new SearcherTracker(indexSearcher);
            if (this.searchers.putIfAbsent(l, searcherTracker) != null) {
                searcherTracker.close();
            }
        } else if (searcherTracker.searcher != indexSearcher) {
            throw new IllegalArgumentException("the provided searcher has the same underlying reader version yet the searcher instance differs from before (new=" + indexSearcher + " vs old=" + searcherTracker.searcher);
        }
        return l;
    }

    public IndexSearcher acquire(long l) {
        this.ensureOpen();
        SearcherTracker searcherTracker = this.searchers.get(l);
        if (searcherTracker != null && searcherTracker.searcher.getIndexReader().tryIncRef()) {
            return searcherTracker.searcher;
        }
        return null;
    }

    public void release(IndexSearcher indexSearcher) throws IOException {
        indexSearcher.getIndexReader().decRef();
    }

    public synchronized void prune(Pruner pruner) throws IOException {
        ArrayList<SearcherTracker> arrayList = new ArrayList<SearcherTracker>();
        for (SearcherTracker searcherTracker : this.searchers.values()) {
            arrayList.add(searcherTracker);
        }
        Collections.sort(arrayList);
        long l = arrayList.isEmpty() ? 0L : ((SearcherTracker)arrayList.get((int)0)).recordTimeSec;
        for (SearcherTracker searcherTracker : arrayList) {
            int n = (int)(l - searcherTracker.recordTimeSec);
            assert (n >= 0);
            if (!pruner.doPrune(n, searcherTracker.searcher)) continue;
            this.searchers.remove(searcherTracker.version);
            searcherTracker.close();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        ArrayList<SearcherTracker> arrayList = new ArrayList<SearcherTracker>(this.searchers.values());
        for (SearcherTracker searcherTracker : arrayList) {
            this.searchers.remove(searcherTracker.version);
        }
        IOUtils.close(arrayList);
        if (this.searchers.size() != 0) {
            throw new IllegalStateException("another thread called record while this SearcherLifetimeManager instance was being closed; not all searchers were closed");
        }
    }

    public static final class PruneByAge
    implements Pruner {
        private final int maxAgeSec;

        public PruneByAge(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("maxAgeSec must be > 0 (got " + n + ")");
            }
            this.maxAgeSec = n;
        }

        @Override
        public boolean doPrune(int n, IndexSearcher indexSearcher) {
            return n > this.maxAgeSec;
        }
    }

    public static interface Pruner {
        public boolean doPrune(int var1, IndexSearcher var2);
    }

    private static class SearcherTracker
    implements Comparable<SearcherTracker>,
    Closeable {
        public final IndexSearcher searcher;
        public final long recordTimeSec;
        public final long version;

        public SearcherTracker(IndexSearcher indexSearcher) {
            this.searcher = indexSearcher;
            this.version = indexSearcher.getIndexReader().getVersion();
            indexSearcher.getIndexReader().incRef();
            this.recordTimeSec = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
        }

        @Override
        public int compareTo(SearcherTracker searcherTracker) {
            if (this.recordTimeSec < searcherTracker.recordTimeSec) {
                return 1;
            }
            if (searcherTracker.recordTimeSec < this.recordTimeSec) {
                return -1;
            }
            return 0;
        }

        @Override
        public synchronized void close() throws IOException {
            this.searcher.getIndexReader().decRef();
        }
    }
}

