/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;

public class PositiveScoresOnlyCollector
extends Collector {
    private final Collector c;
    private Scorer scorer;

    public PositiveScoresOnlyCollector(Collector collector) {
        this.c = collector;
    }

    @Override
    public void collect(int n) throws IOException {
        if (this.scorer.score() > 0.0f) {
            this.c.collect(n);
        }
    }

    @Override
    public void setNextReader(IndexReader indexReader, int n) throws IOException {
        this.c.setNextReader(indexReader, n);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = new ScoreCachingWrappingScorer(scorer);
        this.c.setScorer(this.scorer);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.c.acceptsDocsOutOfOrder();
    }
}

